/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.eclipse.aether.internal.impl;

import io.quarkus.launcher.shaded.javax.inject.Inject;
import io.quarkus.launcher.shaded.javax.inject.Named;
import io.quarkus.launcher.shaded.org.eclipse.aether.RepositorySystemSession;
import io.quarkus.launcher.shaded.org.eclipse.aether.internal.impl.PrioritizedComponent;
import io.quarkus.launcher.shaded.org.eclipse.aether.internal.impl.PrioritizedComponents;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.RemoteRepository;
import io.quarkus.launcher.shaded.org.eclipse.aether.spi.connector.layout.RepositoryLayout;
import io.quarkus.launcher.shaded.org.eclipse.aether.spi.connector.layout.RepositoryLayoutFactory;
import io.quarkus.launcher.shaded.org.eclipse.aether.spi.connector.layout.RepositoryLayoutProvider;
import io.quarkus.launcher.shaded.org.eclipse.aether.spi.locator.Service;
import io.quarkus.launcher.shaded.org.eclipse.aether.spi.locator.ServiceLocator;
import io.quarkus.launcher.shaded.org.eclipse.aether.transfer.NoRepositoryLayoutException;
import io.quarkus.launcher.shaded.org.slf4j.Logger;
import io.quarkus.launcher.shaded.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;

@Named
public final class DefaultRepositoryLayoutProvider
implements RepositoryLayoutProvider,
Service {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRepositoryLayoutProvider.class);
    private Collection<RepositoryLayoutFactory> factories = new ArrayList<RepositoryLayoutFactory>();

    public DefaultRepositoryLayoutProvider() {
    }

    @Inject
    DefaultRepositoryLayoutProvider(Set<RepositoryLayoutFactory> layoutFactories) {
        this.setRepositoryLayoutFactories(layoutFactories);
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.setRepositoryLayoutFactories(locator.getServices(RepositoryLayoutFactory.class));
    }

    public DefaultRepositoryLayoutProvider addRepositoryLayoutFactory(RepositoryLayoutFactory factory) {
        this.factories.add(Objects.requireNonNull(factory, "io.quarkus.launcher.shaded.layout factory cannot be null"));
        return this;
    }

    public DefaultRepositoryLayoutProvider setRepositoryLayoutFactories(Collection<RepositoryLayoutFactory> factories) {
        this.factories = factories == null ? new ArrayList<RepositoryLayoutFactory>() : factories;
        return this;
    }

    @Override
    public RepositoryLayout newRepositoryLayout(RepositorySystemSession session, RemoteRepository repository) throws NoRepositoryLayoutException {
        Objects.requireNonNull(repository, "io.quarkus.launcher.shaded.remote repository cannot be null");
        PrioritizedComponents<RepositoryLayoutFactory> factories = new PrioritizedComponents<RepositoryLayoutFactory>(session);
        for (RepositoryLayoutFactory factory : this.factories) {
            factories.add(factory, factory.getPriority());
        }
        ArrayList<NoRepositoryLayoutException> errors = new ArrayList<NoRepositoryLayoutException>();
        for (PrioritizedComponent factory : factories.getEnabled()) {
            try {
                return ((RepositoryLayoutFactory)factory.getComponent()).newInstance(session, repository);
            }
            catch (NoRepositoryLayoutException noRepositoryLayoutException) {
                errors.add(noRepositoryLayoutException);
            }
        }
        if (LOGGER.isDebugEnabled() && errors.size() > 1) {
            String msg = "io.quarkus.launcher.shaded.Could not obtain layout factory for " + repository;
            for (Exception exception : errors) {
                LOGGER.debug(msg, exception);
            }
        }
        StringBuilder buffer = new StringBuilder(256);
        if (factories.isEmpty()) {
            buffer.append("io.quarkus.launcher.shaded.No layout factories registered");
        } else {
            buffer.append("io.quarkus.launcher.shaded.Cannot access ").append(repository.getUrl());
            buffer.append("io.quarkus.launcher.shaded. with type ").append(repository.getContentType());
            buffer.append("io.quarkus.launcher.shaded. using the available layout factories: ");
            factories.list(buffer);
        }
        throw new NoRepositoryLayoutException(repository, buffer.toString(), errors.size() == 1 ? (NoRepositoryLayoutException)errors.get(0) : null);
    }
}

