/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.eclipse.aether.internal.impl;

import io.quarkus.launcher.shaded.javax.inject.Inject;
import io.quarkus.launcher.shaded.javax.inject.Named;
import io.quarkus.launcher.shaded.org.eclipse.aether.RepositorySystemSession;
import io.quarkus.launcher.shaded.org.eclipse.aether.internal.impl.PrioritizedComponent;
import io.quarkus.launcher.shaded.org.eclipse.aether.internal.impl.PrioritizedComponents;
import io.quarkus.launcher.shaded.org.eclipse.aether.internal.impl.Utils;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.RemoteRepository;
import io.quarkus.launcher.shaded.org.eclipse.aether.spi.connector.transport.Transporter;
import io.quarkus.launcher.shaded.org.eclipse.aether.spi.connector.transport.TransporterFactory;
import io.quarkus.launcher.shaded.org.eclipse.aether.spi.connector.transport.TransporterProvider;
import io.quarkus.launcher.shaded.org.eclipse.aether.spi.locator.Service;
import io.quarkus.launcher.shaded.org.eclipse.aether.spi.locator.ServiceLocator;
import io.quarkus.launcher.shaded.org.eclipse.aether.transfer.NoTransporterException;
import io.quarkus.launcher.shaded.org.slf4j.Logger;
import io.quarkus.launcher.shaded.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;

@Named
public final class DefaultTransporterProvider
implements TransporterProvider,
Service {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultTransporterProvider.class);
    private Collection<TransporterFactory> factories = new ArrayList<TransporterFactory>();

    public DefaultTransporterProvider() {
    }

    @Inject
    DefaultTransporterProvider(Set<TransporterFactory> transporterFactories) {
        this.setTransporterFactories(transporterFactories);
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.setTransporterFactories(locator.getServices(TransporterFactory.class));
    }

    public DefaultTransporterProvider addTransporterFactory(TransporterFactory factory) {
        this.factories.add(Objects.requireNonNull(factory, "io.quarkus.launcher.shaded.transporter factory cannot be null"));
        return this;
    }

    public DefaultTransporterProvider setTransporterFactories(Collection<TransporterFactory> factories) {
        this.factories = factories == null ? new ArrayList<TransporterFactory>() : factories;
        return this;
    }

    @Override
    public Transporter newTransporter(RepositorySystemSession session, RemoteRepository repository) throws NoTransporterException {
        Objects.requireNonNull(repository, "io.quarkus.launcher.shaded.remote repository cannot be null");
        PrioritizedComponents<TransporterFactory> factories = new PrioritizedComponents<TransporterFactory>(session);
        for (TransporterFactory factory : this.factories) {
            factories.add(factory, factory.getPriority());
        }
        ArrayList<NoTransporterException> errors = new ArrayList<NoTransporterException>();
        for (PrioritizedComponent factory : factories.getEnabled()) {
            try {
                Transporter transporter = ((TransporterFactory)factory.getComponent()).newInstance(session, repository);
                if (LOGGER.isDebugEnabled()) {
                    StringBuilder buffer = new StringBuilder(256);
                    buffer.append("io.quarkus.launcher.shaded.Using transporter ").append(transporter.getClass().getSimpleName());
                    Utils.appendClassLoader(buffer, transporter);
                    buffer.append("io.quarkus.launcher.shaded. with priority ").append(factory.getPriority());
                    buffer.append("io.quarkus.launcher.shaded. for ").append(repository.getUrl());
                    LOGGER.debug(buffer.toString());
                }
                return transporter;
            }
            catch (NoTransporterException noTransporterException) {
                errors.add(noTransporterException);
            }
        }
        if (LOGGER.isDebugEnabled() && errors.size() > 1) {
            String msg = "io.quarkus.launcher.shaded.Could not obtain transporter factory for " + repository;
            for (Exception exception : errors) {
                LOGGER.debug(msg, exception);
            }
        }
        StringBuilder buffer = new StringBuilder(256);
        if (factories.isEmpty()) {
            buffer.append("io.quarkus.launcher.shaded.No transporter factories registered");
        } else {
            buffer.append("io.quarkus.launcher.shaded.Cannot access ").append(repository.getUrl());
            buffer.append("io.quarkus.launcher.shaded. using the registered transporter factories: ");
            factories.list(buffer);
        }
        throw new NoTransporterException(repository, buffer.toString(), errors.size() == 1 ? (NoTransporterException)errors.get(0) : null);
    }
}

