/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.eclipse.aether.internal.impl;

import io.quarkus.launcher.shaded.javax.inject.Named;
import io.quarkus.launcher.shaded.org.eclipse.aether.RepositorySystemSession;
import io.quarkus.launcher.shaded.org.eclipse.aether.impl.UpdatePolicyAnalyzer;
import io.quarkus.launcher.shaded.org.slf4j.Logger;
import io.quarkus.launcher.shaded.org.slf4j.LoggerFactory;
import java.util.Calendar;

@Named
public class DefaultUpdatePolicyAnalyzer
implements UpdatePolicyAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultUpdatePolicyAnalyzer.class);

    @Override
    public String getEffectiveUpdatePolicy(RepositorySystemSession session, String policy1, String policy2) {
        return this.ordinalOfUpdatePolicy(policy1) < this.ordinalOfUpdatePolicy(policy2) ? policy1 : policy2;
    }

    private int ordinalOfUpdatePolicy(String policy) {
        if ("io.quarkus.launcher.shaded.daily".equals(policy)) {
            return 1440;
        }
        if ("io.quarkus.launcher.shaded.always".equals(policy)) {
            return 0;
        }
        if (policy != null && policy.startsWith("io.quarkus.launcher.shaded.interval")) {
            return this.getMinutes(policy);
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean isUpdatedRequired(RepositorySystemSession session, long lastModified, String policy) {
        boolean checkForUpdates;
        if (policy == null) {
            policy = "io.quarkus.launcher.shaded.";
        }
        if ("io.quarkus.launcher.shaded.always".equals(policy)) {
            checkForUpdates = true;
        } else if ("io.quarkus.launcher.shaded.daily".equals(policy)) {
            Calendar cal = Calendar.getInstance();
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            checkForUpdates = cal.getTimeInMillis() > lastModified;
        } else if (policy.startsWith("io.quarkus.launcher.shaded.interval")) {
            int minutes = this.getMinutes(policy);
            Calendar cal = Calendar.getInstance();
            cal.add(12, -minutes);
            checkForUpdates = cal.getTimeInMillis() > lastModified;
        } else {
            checkForUpdates = false;
            if (!"io.quarkus.launcher.shaded.never".equals(policy)) {
                LOGGER.warn("io.quarkus.launcher.shaded.Unknown repository update policy '{}', assuming '{}'", (Object)policy, (Object)"io.quarkus.launcher.shaded.never");
            }
        }
        return checkForUpdates;
    }

    private int getMinutes(String policy) {
        int minutes;
        try {
            String s = policy.substring("io.quarkus.launcher.shaded.interval".length() + 1);
            minutes = Integer.valueOf(s);
        }
        catch (RuntimeException e) {
            minutes = 1440;
            LOGGER.warn("io.quarkus.launcher.shaded.Non-parseable repository update policy '{}', assuming '{}:1440'", (Object)policy, (Object)"io.quarkus.launcher.shaded.interval");
        }
        return minutes;
    }
}

