/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.eclipse.aether.internal.impl;

import io.quarkus.launcher.shaded.javax.inject.Named;
import io.quarkus.launcher.shaded.org.eclipse.aether.RepositorySystemSession;
import io.quarkus.launcher.shaded.org.eclipse.aether.artifact.Artifact;
import io.quarkus.launcher.shaded.org.eclipse.aether.metadata.Metadata;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.RemoteRepository;
import io.quarkus.launcher.shaded.org.eclipse.aether.spi.connector.layout.RepositoryLayout;
import io.quarkus.launcher.shaded.org.eclipse.aether.spi.connector.layout.RepositoryLayoutFactory;
import io.quarkus.launcher.shaded.org.eclipse.aether.transfer.NoRepositoryLayoutException;
import io.quarkus.launcher.shaded.org.eclipse.aether.util.ConfigUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@Named(value="io.quarkus.launcher.shaded.maven2")
public final class Maven2RepositoryLayoutFactory
implements RepositoryLayoutFactory {
    static final String CONFIG_PROP_SIGNATURE_CHECKSUMS = "io.quarkus.launcher.shaded.aether.checksums.forSignature";
    private float priority;

    @Override
    public float getPriority() {
        return this.priority;
    }

    public Maven2RepositoryLayoutFactory setPriority(float priority) {
        this.priority = priority;
        return this;
    }

    @Override
    public RepositoryLayout newInstance(RepositorySystemSession session, RemoteRepository repository) throws NoRepositoryLayoutException {
        if (!"io.quarkus.launcher.shaded.default".equals(repository.getContentType())) {
            throw new NoRepositoryLayoutException(repository);
        }
        boolean forSignature = ConfigUtils.getBoolean(session, false, CONFIG_PROP_SIGNATURE_CHECKSUMS);
        return forSignature ? Maven2RepositoryLayout.INSTANCE : Maven2RepositoryLayoutEx.INSTANCE;
    }

    private static class Maven2RepositoryLayoutEx
    extends Maven2RepositoryLayout {
        public static final RepositoryLayout INSTANCE = new Maven2RepositoryLayoutEx();

        private Maven2RepositoryLayoutEx() {
        }

        @Override
        public List<RepositoryLayout.Checksum> getChecksums(Artifact artifact, boolean upload, URI location) {
            if (this.isSignature(artifact.getExtension())) {
                return Collections.emptyList();
            }
            return super.getChecksums(artifact, upload, location);
        }

        private boolean isSignature(String extension) {
            return extension.endsWith("io.quarkus.launcher.shaded..asc");
        }
    }

    private static class Maven2RepositoryLayout
    implements RepositoryLayout {
        public static final RepositoryLayout INSTANCE = new Maven2RepositoryLayout();

        private Maven2RepositoryLayout() {
        }

        private URI toUri(String path) {
            try {
                return new URI(null, null, path, null);
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public URI getLocation(Artifact artifact, boolean upload) {
            StringBuilder path = new StringBuilder(128);
            path.append(artifact.getGroupId().replace('.', '/')).append('/');
            path.append(artifact.getArtifactId()).append('/');
            path.append(artifact.getBaseVersion()).append('/');
            path.append(artifact.getArtifactId()).append('-').append(artifact.getVersion());
            if (artifact.getClassifier().length() > 0) {
                path.append('-').append(artifact.getClassifier());
            }
            if (artifact.getExtension().length() > 0) {
                path.append('.').append(artifact.getExtension());
            }
            return this.toUri(path.toString());
        }

        @Override
        public URI getLocation(Metadata metadata, boolean upload) {
            StringBuilder path = new StringBuilder(128);
            if (metadata.getGroupId().length() > 0) {
                path.append(metadata.getGroupId().replace('.', '/')).append('/');
                if (metadata.getArtifactId().length() > 0) {
                    path.append(metadata.getArtifactId()).append('/');
                    if (metadata.getVersion().length() > 0) {
                        path.append(metadata.getVersion()).append('/');
                    }
                }
            }
            path.append(metadata.getType());
            return this.toUri(path.toString());
        }

        @Override
        public List<RepositoryLayout.Checksum> getChecksums(Artifact artifact, boolean upload, URI location) {
            return this.getChecksums(location);
        }

        @Override
        public List<RepositoryLayout.Checksum> getChecksums(Metadata metadata, boolean upload, URI location) {
            return this.getChecksums(location);
        }

        private List<RepositoryLayout.Checksum> getChecksums(URI location) {
            return Arrays.asList(RepositoryLayout.Checksum.forLocation(location, "io.quarkus.launcher.shaded.SHA-1"), RepositoryLayout.Checksum.forLocation(location, "io.quarkus.launcher.shaded.MD5"));
        }
    }
}

