/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.eclipse.aether.internal.impl;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

class SimpleDigest {
    private MessageDigest digest;
    private long hash;

    SimpleDigest() {
        try {
            this.digest = MessageDigest.getInstance("io.quarkus.launcher.shaded.SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            try {
                this.digest = MessageDigest.getInstance("io.quarkus.launcher.shaded.MD5");
            }
            catch (NoSuchAlgorithmException ne) {
                this.digest = null;
                this.hash = 13L;
            }
        }
    }

    public void update(String data) {
        if (data == null || data.length() <= 0) {
            return;
        }
        if (this.digest != null) {
            this.digest.update(data.getBytes(StandardCharsets.UTF_8));
        } else {
            this.hash = this.hash * 31L + (long)data.hashCode();
        }
    }

    public String digest() {
        if (this.digest != null) {
            byte[] bytes;
            StringBuilder buffer = new StringBuilder(64);
            for (byte aByte : bytes = this.digest.digest()) {
                int b = aByte & 0xFF;
                if (b < 16) {
                    buffer.append('0');
                }
                buffer.append(Integer.toHexString(b));
            }
            return buffer.toString();
        }
        return Long.toHexString(this.hash);
    }
}

