/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.eclipse.aether.internal.transport.wagon;

import io.quarkus.launcher.shaded.javax.inject.Inject;
import io.quarkus.launcher.shaded.javax.inject.Named;
import io.quarkus.launcher.shaded.javax.inject.Singleton;
import io.quarkus.launcher.shaded.org.apache.maven.wagon.Wagon;
import io.quarkus.launcher.shaded.org.codehaus.plexus.PlexusContainer;
import io.quarkus.launcher.shaded.org.codehaus.plexus.classworlds.realm.ClassRealm;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.configurator.AbstractComponentConfigurator;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.configurator.ConfigurationListener;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.configurator.converters.composite.ObjectWithFieldsConverter;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import io.quarkus.launcher.shaded.org.codehaus.plexus.configuration.PlexusConfiguration;
import io.quarkus.launcher.shaded.org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import io.quarkus.launcher.shaded.org.codehaus.plexus.util.xml.Xpp3Dom;
import io.quarkus.launcher.shaded.org.eclipse.aether.transport.wagon.WagonConfigurator;
import java.util.Objects;

@Named(value="io.quarkus.launcher.shaded.plexus")
@Singleton
public class PlexusWagonConfigurator
implements WagonConfigurator {
    private PlexusContainer container;

    @Inject
    public PlexusWagonConfigurator(PlexusContainer container) {
        this.container = Objects.requireNonNull(container, "io.quarkus.launcher.shaded.plexus container cannot be null");
    }

    @Override
    public void configure(Wagon wagon, Object configuration) throws Exception {
        PlexusConfiguration config;
        if (configuration instanceof PlexusConfiguration) {
            config = (PlexusConfiguration)configuration;
        } else if (configuration instanceof Xpp3Dom) {
            config = new XmlPlexusConfiguration((Xpp3Dom)configuration);
        } else {
            if (configuration == null) {
                return;
            }
            throw new IllegalArgumentException("io.quarkus.launcher.shaded.unexpected configuration type: " + configuration.getClass().getName());
        }
        WagonComponentConfigurator configurator = new WagonComponentConfigurator();
        configurator.configureComponent(wagon, config, this.container.getContainerRealm());
    }

    static class WagonComponentConfigurator
    extends AbstractComponentConfigurator {
        WagonComponentConfigurator() {
        }

        @Override
        public void configureComponent(Object component, PlexusConfiguration configuration, ExpressionEvaluator expressionEvaluator, ClassRealm containerRealm, ConfigurationListener listener) throws ComponentConfigurationException {
            ObjectWithFieldsConverter converter = new ObjectWithFieldsConverter();
            converter.processConfiguration(this.converterLookup, component, containerRealm, configuration, expressionEvaluator, listener);
        }
    }
}

