/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.eclipse.aether.metadata;

import io.quarkus.launcher.shaded.org.eclipse.aether.metadata.AbstractMetadata;
import io.quarkus.launcher.shaded.org.eclipse.aether.metadata.Metadata;
import java.io.File;
import java.util.Map;
import java.util.Objects;

public final class DefaultMetadata
extends AbstractMetadata {
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String type;
    private final Metadata.Nature nature;
    private final File file;
    private final Map<String, String> properties;

    public DefaultMetadata(String type, Metadata.Nature nature) {
        this("io.quarkus.launcher.shaded.", "io.quarkus.launcher.shaded.", "io.quarkus.launcher.shaded.", type, nature, null, (File)null);
    }

    public DefaultMetadata(String groupId, String type, Metadata.Nature nature) {
        this(groupId, "io.quarkus.launcher.shaded.", "io.quarkus.launcher.shaded.", type, nature, null, (File)null);
    }

    public DefaultMetadata(String groupId, String artifactId, String type, Metadata.Nature nature) {
        this(groupId, artifactId, "io.quarkus.launcher.shaded.", type, nature, null, (File)null);
    }

    public DefaultMetadata(String groupId, String artifactId, String version, String type, Metadata.Nature nature) {
        this(groupId, artifactId, version, type, nature, null, (File)null);
    }

    public DefaultMetadata(String groupId, String artifactId, String version, String type, Metadata.Nature nature, File file) {
        this(groupId, artifactId, version, type, nature, null, file);
    }

    public DefaultMetadata(String groupId, String artifactId, String version, String type, Metadata.Nature nature, Map<String, String> properties, File file) {
        this.groupId = DefaultMetadata.emptify(groupId);
        this.artifactId = DefaultMetadata.emptify(artifactId);
        this.version = DefaultMetadata.emptify(version);
        this.type = DefaultMetadata.emptify(type);
        this.nature = Objects.requireNonNull(nature, "io.quarkus.launcher.shaded.metadata nature cannot be null");
        this.file = file;
        this.properties = DefaultMetadata.copyProperties(properties);
    }

    DefaultMetadata(String groupId, String artifactId, String version, String type, Metadata.Nature nature, File file, Map<String, String> properties) {
        this.groupId = DefaultMetadata.emptify(groupId);
        this.artifactId = DefaultMetadata.emptify(artifactId);
        this.version = DefaultMetadata.emptify(version);
        this.type = DefaultMetadata.emptify(type);
        this.nature = nature;
        this.file = file;
        this.properties = properties;
    }

    private static String emptify(String str) {
        return str == null ? "io.quarkus.launcher.shaded." : str;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Metadata.Nature getNature() {
        return this.nature;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }
}

