/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.eclipse.aether.repository;

import io.quarkus.launcher.shaded.org.eclipse.aether.RepositoryException;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.LocalRepository;

public class NoLocalRepositoryManagerException
extends RepositoryException {
    private final transient LocalRepository repository;

    public NoLocalRepositoryManagerException(LocalRepository repository) {
        this(repository, NoLocalRepositoryManagerException.toMessage(repository));
    }

    public NoLocalRepositoryManagerException(LocalRepository repository, String message) {
        super(message);
        this.repository = repository;
    }

    public NoLocalRepositoryManagerException(LocalRepository repository, Throwable cause) {
        this(repository, NoLocalRepositoryManagerException.toMessage(repository), cause);
    }

    public NoLocalRepositoryManagerException(LocalRepository repository, String message, Throwable cause) {
        super(message, cause);
        this.repository = repository;
    }

    private static String toMessage(LocalRepository repository) {
        if (repository != null) {
            return "io.quarkus.launcher.shaded.No manager available for local repository (" + repository.getBasedir().getAbsolutePath() + "io.quarkus.launcher.shaded.) of type " + repository.getContentType();
        }
        return "io.quarkus.launcher.shaded.No manager available for local repository";
    }

    public LocalRepository getRepository() {
        return this.repository;
    }
}

