/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.eclipse.aether.repository;

public final class RepositoryPolicy {
    public static final String UPDATE_POLICY_NEVER = "io.quarkus.launcher.shaded.never";
    public static final String UPDATE_POLICY_ALWAYS = "io.quarkus.launcher.shaded.always";
    public static final String UPDATE_POLICY_DAILY = "io.quarkus.launcher.shaded.daily";
    public static final String UPDATE_POLICY_INTERVAL = "io.quarkus.launcher.shaded.interval";
    public static final String CHECKSUM_POLICY_FAIL = "io.quarkus.launcher.shaded.fail";
    public static final String CHECKSUM_POLICY_WARN = "io.quarkus.launcher.shaded.warn";
    public static final String CHECKSUM_POLICY_IGNORE = "io.quarkus.launcher.shaded.ignore";
    private final boolean enabled;
    private final String updatePolicy;
    private final String checksumPolicy;

    public RepositoryPolicy() {
        this(true, UPDATE_POLICY_DAILY, CHECKSUM_POLICY_WARN);
    }

    public RepositoryPolicy(boolean enabled, String updatePolicy, String checksumPolicy) {
        this.enabled = enabled;
        this.updatePolicy = updatePolicy != null ? updatePolicy : "io.quarkus.launcher.shaded.";
        this.checksumPolicy = checksumPolicy != null ? checksumPolicy : "io.quarkus.launcher.shaded.";
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getUpdatePolicy() {
        return this.updatePolicy;
    }

    public String getChecksumPolicy() {
        return this.checksumPolicy;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append("io.quarkus.launcher.shaded.enabled=").append(this.isEnabled());
        buffer.append("io.quarkus.launcher.shaded., checksums=").append(this.getChecksumPolicy());
        buffer.append("io.quarkus.launcher.shaded., updates=").append(this.getUpdatePolicy());
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        RepositoryPolicy that = (RepositoryPolicy)obj;
        return this.enabled == that.enabled && this.updatePolicy.equals(that.updatePolicy) && this.checksumPolicy.equals(that.checksumPolicy);
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + (this.enabled ? 1 : 0);
        hash = hash * 31 + this.updatePolicy.hashCode();
        hash = hash * 31 + this.checksumPolicy.hashCode();
        return hash;
    }
}

