/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.eclipse.aether.resolution;

import io.quarkus.launcher.shaded.org.eclipse.aether.RepositoryException;
import io.quarkus.launcher.shaded.org.eclipse.aether.resolution.ArtifactResult;
import io.quarkus.launcher.shaded.org.eclipse.aether.transfer.ArtifactNotFoundException;
import io.quarkus.launcher.shaded.org.eclipse.aether.transfer.RepositoryOfflineException;
import java.util.Collections;
import java.util.List;

public class ArtifactResolutionException
extends RepositoryException {
    private final transient List<ArtifactResult> results;

    public ArtifactResolutionException(List<ArtifactResult> results) {
        super(ArtifactResolutionException.getMessage(results), ArtifactResolutionException.getCause(results));
        this.results = results != null ? results : Collections.emptyList();
    }

    public ArtifactResolutionException(List<ArtifactResult> results, String message) {
        super(message, ArtifactResolutionException.getCause(results));
        this.results = results != null ? results : Collections.emptyList();
    }

    public ArtifactResolutionException(List<ArtifactResult> results, String message, Throwable cause) {
        super(message, cause);
        this.results = results != null ? results : Collections.emptyList();
    }

    public List<ArtifactResult> getResults() {
        return this.results;
    }

    public ArtifactResult getResult() {
        return this.results != null && !this.results.isEmpty() ? this.results.get(0) : null;
    }

    private static String getMessage(List<? extends ArtifactResult> results) {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append("io.quarkus.launcher.shaded.The following artifacts could not be resolved: ");
        int unresolved = 0;
        String sep = "io.quarkus.launcher.shaded.";
        for (ArtifactResult artifactResult : results) {
            if (artifactResult.isResolved()) continue;
            ++unresolved;
            buffer.append(sep);
            buffer.append(artifactResult.getRequest().getArtifact());
            sep = "io.quarkus.launcher.shaded., ";
        }
        Throwable cause = ArtifactResolutionException.getCause(results);
        if (cause != null) {
            if (unresolved == 1) {
                buffer.setLength(0);
                buffer.append(cause.getMessage());
            } else {
                buffer.append("io.quarkus.launcher.shaded.: ").append(cause.getMessage());
            }
        }
        return buffer.toString();
    }

    private static Throwable getCause(List<? extends ArtifactResult> results) {
        for (ArtifactResult artifactResult : results) {
            if (artifactResult.isResolved()) continue;
            Throwable notFound = null;
            Throwable offline = null;
            for (Throwable throwable : artifactResult.getExceptions()) {
                if (throwable instanceof ArtifactNotFoundException) {
                    if (notFound == null) {
                        notFound = throwable;
                    }
                    if (offline != null || !(throwable.getCause() instanceof RepositoryOfflineException)) continue;
                    offline = throwable;
                    continue;
                }
                return throwable;
            }
            if (offline != null) {
                return offline;
            }
            if (notFound == null) continue;
            return notFound;
        }
        return null;
    }
}

