/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.eclipse.aether.resolution;

import io.quarkus.launcher.shaded.org.eclipse.aether.RepositoryException;
import io.quarkus.launcher.shaded.org.eclipse.aether.resolution.VersionRangeResult;

public class VersionRangeResolutionException
extends RepositoryException {
    private final transient VersionRangeResult result;

    public VersionRangeResolutionException(VersionRangeResult result) {
        super(VersionRangeResolutionException.getMessage(result), VersionRangeResolutionException.getCause(result));
        this.result = result;
    }

    private static String getMessage(VersionRangeResult result) {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append("io.quarkus.launcher.shaded.Failed to resolve version range");
        if (result != null) {
            buffer.append("io.quarkus.launcher.shaded. for ").append(result.getRequest().getArtifact());
            if (!result.getExceptions().isEmpty()) {
                buffer.append("io.quarkus.launcher.shaded.: ").append(result.getExceptions().iterator().next().getMessage());
            }
        }
        return buffer.toString();
    }

    private static Throwable getCause(VersionRangeResult result) {
        Throwable cause = null;
        if (result != null && !result.getExceptions().isEmpty()) {
            cause = result.getExceptions().get(0);
        }
        return cause;
    }

    public VersionRangeResolutionException(VersionRangeResult result, String message) {
        super(message);
        this.result = result;
    }

    public VersionRangeResolutionException(VersionRangeResult result, String message, Throwable cause) {
        super(message, cause);
        this.result = result;
    }

    public VersionRangeResult getResult() {
        return this.result;
    }
}

