/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.eclipse.aether.resolution;

import io.quarkus.launcher.shaded.org.eclipse.aether.repository.ArtifactRepository;
import io.quarkus.launcher.shaded.org.eclipse.aether.resolution.VersionRangeRequest;
import io.quarkus.launcher.shaded.org.eclipse.aether.version.Version;
import io.quarkus.launcher.shaded.org.eclipse.aether.version.VersionConstraint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class VersionRangeResult {
    private final VersionRangeRequest request;
    private List<Exception> exceptions;
    private List<Version> versions;
    private Map<Version, ArtifactRepository> repositories;
    private VersionConstraint versionConstraint;

    public VersionRangeResult(VersionRangeRequest request) {
        this.request = Objects.requireNonNull(request, "io.quarkus.launcher.shaded.version range request cannot be null");
        this.exceptions = Collections.emptyList();
        this.versions = Collections.emptyList();
        this.repositories = Collections.emptyMap();
    }

    public VersionRangeRequest getRequest() {
        return this.request;
    }

    public List<Exception> getExceptions() {
        return this.exceptions;
    }

    public VersionRangeResult addException(Exception exception) {
        if (exception != null) {
            if (this.exceptions.isEmpty()) {
                this.exceptions = new ArrayList<Exception>();
            }
            this.exceptions.add(exception);
        }
        return this;
    }

    public List<Version> getVersions() {
        return this.versions;
    }

    public VersionRangeResult addVersion(Version version) {
        if (this.versions.isEmpty()) {
            this.versions = new ArrayList<Version>();
        }
        this.versions.add(version);
        return this;
    }

    public VersionRangeResult setVersions(List<Version> versions) {
        this.versions = versions == null ? Collections.emptyList() : versions;
        return this;
    }

    public Version getLowestVersion() {
        if (this.versions.isEmpty()) {
            return null;
        }
        return this.versions.get(0);
    }

    public Version getHighestVersion() {
        if (this.versions.isEmpty()) {
            return null;
        }
        return this.versions.get(this.versions.size() - 1);
    }

    public ArtifactRepository getRepository(Version version) {
        return this.repositories.get(version);
    }

    public VersionRangeResult setRepository(Version version, ArtifactRepository repository) {
        if (repository != null) {
            if (this.repositories.isEmpty()) {
                this.repositories = new HashMap<Version, ArtifactRepository>();
            }
            this.repositories.put(version, repository);
        }
        return this;
    }

    public VersionConstraint getVersionConstraint() {
        return this.versionConstraint;
    }

    public VersionRangeResult setVersionConstraint(VersionConstraint versionConstraint) {
        this.versionConstraint = versionConstraint;
        return this;
    }

    public String toString() {
        return String.valueOf(this.repositories);
    }
}

