/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.eclipse.aether.spi.connector.layout;

import io.quarkus.launcher.shaded.org.eclipse.aether.artifact.Artifact;
import io.quarkus.launcher.shaded.org.eclipse.aether.metadata.Metadata;
import java.net.URI;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

public interface RepositoryLayout {
    public URI getLocation(Artifact var1, boolean var2);

    public URI getLocation(Metadata var1, boolean var2);

    public List<Checksum> getChecksums(Artifact var1, boolean var2, URI var3);

    public List<Checksum> getChecksums(Metadata var1, boolean var2, URI var3);

    public static final class Checksum {
        private final String algorithm;
        private final URI location;

        public Checksum(String algorithm, URI location) {
            Checksum.verify(algorithm, location);
            this.algorithm = algorithm;
            this.location = location;
        }

        public static Checksum forLocation(URI location, String algorithm) {
            Checksum.verify(algorithm, location);
            if (location.getRawQuery() != null) {
                throw new IllegalArgumentException("io.quarkus.launcher.shaded.resource location must not have query parameters: " + location);
            }
            if (location.getRawFragment() != null) {
                throw new IllegalArgumentException("io.quarkus.launcher.shaded.resource location must not have a fragment: " + location);
            }
            String extension = '.' + algorithm.replace("io.quarkus.launcher.shaded.-", "io.quarkus.launcher.shaded.").toLowerCase(Locale.ENGLISH);
            return new Checksum(algorithm, URI.create(location.toString() + extension));
        }

        private static void verify(String algorithm, URI location) {
            Objects.requireNonNull(algorithm, "io.quarkus.launcher.shaded.checksum algorithm cannot be null");
            if (algorithm.length() == 0) {
                throw new IllegalArgumentException("io.quarkus.launcher.shaded.checksum algorithm cannot be empty");
            }
            Objects.requireNonNull(location, "io.quarkus.launcher.shaded.checksum location cannot be null");
            if (location.isAbsolute()) {
                throw new IllegalArgumentException("io.quarkus.launcher.shaded.checksum location must be relative");
            }
        }

        public String getAlgorithm() {
            return this.algorithm;
        }

        public URI getLocation() {
            return this.location;
        }

        public String toString() {
            return this.location + "io.quarkus.launcher.shaded. (" + this.algorithm + "io.quarkus.launcher.shaded.)";
        }
    }
}

