/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.eclipse.aether.transfer;

import io.quarkus.launcher.shaded.org.eclipse.aether.artifact.Artifact;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.RemoteRepository;
import io.quarkus.launcher.shaded.org.eclipse.aether.transfer.ArtifactTransferException;

public class ArtifactNotFoundException
extends ArtifactTransferException {
    public ArtifactNotFoundException(Artifact artifact, RemoteRepository repository) {
        super(artifact, repository, ArtifactNotFoundException.getMessage(artifact, repository));
    }

    private static String getMessage(Artifact artifact, RemoteRepository repository) {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append("io.quarkus.launcher.shaded.Could not find artifact ").append(artifact);
        buffer.append(ArtifactNotFoundException.getString("io.quarkus.launcher.shaded. in ", repository));
        if (artifact != null) {
            String downloadUrl;
            String localPath = artifact.getProperty("io.quarkus.launcher.shaded.localPath", null);
            if (localPath != null && repository == null) {
                buffer.append("io.quarkus.launcher.shaded. at specified path ").append(localPath);
            }
            if ((downloadUrl = artifact.getProperty("io.quarkus.launcher.shaded.downloadUrl", null)) != null) {
                buffer.append("io.quarkus.launcher.shaded., try downloading from ").append(downloadUrl);
            }
        }
        return buffer.toString();
    }

    public ArtifactNotFoundException(Artifact artifact, RemoteRepository repository, String message) {
        super(artifact, repository, message);
    }

    public ArtifactNotFoundException(Artifact artifact, RemoteRepository repository, String message, boolean fromCache) {
        super(artifact, repository, message, fromCache);
    }

    public ArtifactNotFoundException(Artifact artifact, RemoteRepository repository, String message, Throwable cause) {
        super(artifact, repository, message, cause);
    }
}

