/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.eclipse.aether.transfer;

import io.quarkus.launcher.shaded.org.eclipse.aether.RepositoryException;
import io.quarkus.launcher.shaded.org.eclipse.aether.artifact.Artifact;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.RemoteRepository;

public class ArtifactTransferException
extends RepositoryException {
    private final transient Artifact artifact;
    private final transient RemoteRepository repository;
    private final boolean fromCache;

    static String getString(String prefix, RemoteRepository repository) {
        if (repository == null) {
            return "io.quarkus.launcher.shaded.";
        }
        return prefix + repository.getId() + "io.quarkus.launcher.shaded. (" + repository.getUrl() + "io.quarkus.launcher.shaded.)";
    }

    public ArtifactTransferException(Artifact artifact, RemoteRepository repository, String message) {
        this(artifact, repository, message, false);
    }

    public ArtifactTransferException(Artifact artifact, RemoteRepository repository, String message, boolean fromCache) {
        super(message);
        this.artifact = artifact;
        this.repository = repository;
        this.fromCache = fromCache;
    }

    public ArtifactTransferException(Artifact artifact, RemoteRepository repository, Throwable cause) {
        this(artifact, repository, "io.quarkus.launcher.shaded.Could not transfer artifact " + artifact + ArtifactTransferException.getString("io/quarkus/launcher/shaded/ from/to ", repository) + ArtifactTransferException.getMessage("io.quarkus.launcher.shaded.: ", cause), cause);
    }

    public ArtifactTransferException(Artifact artifact, RemoteRepository repository, String message, Throwable cause) {
        super(message, cause);
        this.artifact = artifact;
        this.repository = repository;
        this.fromCache = false;
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public RemoteRepository getRepository() {
        return this.repository;
    }

    public boolean isFromCache() {
        return this.fromCache;
    }
}

