/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.eclipse.aether.transfer;

import io.quarkus.launcher.shaded.org.eclipse.aether.RepositoryException;

public class ChecksumFailureException
extends RepositoryException {
    private final String expected;
    private final String actual;
    private final boolean retryWorthy;

    public ChecksumFailureException(String expected, String actual) {
        super("io.quarkus.launcher.shaded.Checksum validation failed, expected " + expected + "io.quarkus.launcher.shaded. but is " + actual);
        this.expected = expected;
        this.actual = actual;
        this.retryWorthy = true;
    }

    public ChecksumFailureException(String message) {
        this(false, message, null);
    }

    public ChecksumFailureException(Throwable cause) {
        this("io.quarkus.launcher.shaded.Checksum validation failed" + ChecksumFailureException.getMessage("io.quarkus.launcher.shaded.: ", cause), cause);
    }

    public ChecksumFailureException(String message, Throwable cause) {
        this(false, message, cause);
    }

    public ChecksumFailureException(boolean retryWorthy, String message, Throwable cause) {
        super(message, cause);
        this.expected = "io.quarkus.launcher.shaded.";
        this.actual = "io.quarkus.launcher.shaded.";
        this.retryWorthy = retryWorthy;
    }

    public String getExpected() {
        return this.expected;
    }

    public String getActual() {
        return this.actual;
    }

    public boolean isRetryWorthy() {
        return this.retryWorthy;
    }
}

