/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.eclipse.aether.transfer;

import io.quarkus.launcher.shaded.org.eclipse.aether.RepositoryException;
import io.quarkus.launcher.shaded.org.eclipse.aether.metadata.Metadata;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.RemoteRepository;

public class MetadataTransferException
extends RepositoryException {
    private final transient Metadata metadata;
    private final transient RemoteRepository repository;
    private final boolean fromCache;

    static String getString(String prefix, RemoteRepository repository) {
        if (repository == null) {
            return "io.quarkus.launcher.shaded.";
        }
        return prefix + repository.getId() + "io.quarkus.launcher.shaded. (" + repository.getUrl() + "io.quarkus.launcher.shaded.)";
    }

    public MetadataTransferException(Metadata metadata, RemoteRepository repository, String message) {
        this(metadata, repository, message, false);
    }

    public MetadataTransferException(Metadata metadata, RemoteRepository repository, String message, boolean fromCache) {
        super(message);
        this.metadata = metadata;
        this.repository = repository;
        this.fromCache = fromCache;
    }

    public MetadataTransferException(Metadata metadata, RemoteRepository repository, Throwable cause) {
        this(metadata, repository, "io.quarkus.launcher.shaded.Could not transfer metadata " + metadata + MetadataTransferException.getString("io/quarkus/launcher/shaded/ from/to ", repository) + MetadataTransferException.getMessage("io.quarkus.launcher.shaded.: ", cause), cause);
    }

    public MetadataTransferException(Metadata metadata, RemoteRepository repository, String message, Throwable cause) {
        super(message, cause);
        this.metadata = metadata;
        this.repository = repository;
        this.fromCache = false;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public RemoteRepository getRepository() {
        return this.repository;
    }

    public boolean isFromCache() {
        return this.fromCache;
    }
}

