/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.eclipse.aether.transfer;

import io.quarkus.launcher.shaded.org.eclipse.aether.RepositoryException;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.RemoteRepository;

public class NoRepositoryConnectorException
extends RepositoryException {
    private final transient RemoteRepository repository;

    public NoRepositoryConnectorException(RemoteRepository repository) {
        this(repository, NoRepositoryConnectorException.toMessage(repository));
    }

    public NoRepositoryConnectorException(RemoteRepository repository, String message) {
        super(message);
        this.repository = repository;
    }

    public NoRepositoryConnectorException(RemoteRepository repository, Throwable cause) {
        this(repository, NoRepositoryConnectorException.toMessage(repository), cause);
    }

    public NoRepositoryConnectorException(RemoteRepository repository, String message, Throwable cause) {
        super(message, cause);
        this.repository = repository;
    }

    private static String toMessage(RemoteRepository repository) {
        if (repository != null) {
            return "io.quarkus.launcher.shaded.No connector available to access repository " + repository.getId() + "io.quarkus.launcher.shaded. (" + repository.getUrl() + "io.quarkus.launcher.shaded.) of type " + repository.getContentType();
        }
        return "io.quarkus.launcher.shaded.No connector available to access repository";
    }

    public RemoteRepository getRepository() {
        return this.repository;
    }
}

