/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.eclipse.aether.transfer;

import io.quarkus.launcher.shaded.org.eclipse.aether.RequestTrace;
import java.io.File;

public final class TransferResource {
    private final String repositoryId;
    private final String repositoryUrl;
    private final String resourceName;
    private final File file;
    private final long startTime;
    private final RequestTrace trace;
    private long contentLength = -1L;
    private long resumeOffset;

    @Deprecated
    public TransferResource(String repositoryUrl, String resourceName, File file, RequestTrace trace) {
        this(null, repositoryUrl, resourceName, file, trace);
    }

    public TransferResource(String repositoryId, String repositoryUrl, String resourceName, File file, RequestTrace trace) {
        this.repositoryId = repositoryId == null || repositoryId.length() <= 0 ? "io.quarkus.launcher.shaded." : repositoryId;
        this.repositoryUrl = repositoryUrl == null || repositoryUrl.length() <= 0 ? "io.quarkus.launcher.shaded." : (repositoryUrl.endsWith("io/quarkus/launcher/shaded//") ? repositoryUrl : repositoryUrl + '/');
        this.resourceName = resourceName == null || resourceName.length() <= 0 ? "io.quarkus.launcher.shaded." : (resourceName.startsWith("io/quarkus/launcher/shaded//") ? resourceName.substring(1) : resourceName);
        this.file = file;
        this.trace = trace;
        this.startTime = System.currentTimeMillis();
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public File getFile() {
        return this.file;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public TransferResource setContentLength(long contentLength) {
        this.contentLength = contentLength;
        return this;
    }

    public long getResumeOffset() {
        return this.resumeOffset;
    }

    public TransferResource setResumeOffset(long resumeOffset) {
        if (resumeOffset < 0L) {
            throw new IllegalArgumentException("io.quarkus.launcher.shaded.resume offset cannot be negative");
        }
        this.resumeOffset = resumeOffset;
        return this;
    }

    public long getTransferStartTime() {
        return this.startTime;
    }

    public RequestTrace getTrace() {
        return this.trace;
    }

    public String toString() {
        return this.getRepositoryUrl() + this.getResourceName() + "io.quarkus.launcher.shaded. <> " + this.getFile();
    }
}

