/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.eclipse.aether.transport.wagon;

import io.quarkus.launcher.shaded.org.apache.maven.wagon.events.TransferEvent;
import io.quarkus.launcher.shaded.org.apache.maven.wagon.observers.AbstractTransferListener;
import io.quarkus.launcher.shaded.org.eclipse.aether.spi.connector.transport.TransportListener;
import io.quarkus.launcher.shaded.org.eclipse.aether.transfer.TransferCancelledException;
import io.quarkus.launcher.shaded.org.eclipse.aether.transport.wagon.WagonCancelledException;
import java.nio.ByteBuffer;

final class WagonTransferListener
extends AbstractTransferListener {
    private final TransportListener listener;

    WagonTransferListener(TransportListener listener) {
        this.listener = listener;
    }

    @Override
    public void transferStarted(TransferEvent event) {
        try {
            this.listener.transportStarted(0L, event.getResource().getContentLength());
        }
        catch (TransferCancelledException transferCancelledException) {
            // empty catch block
        }
    }

    @Override
    public void transferProgress(TransferEvent event, byte[] buffer, int length) {
        try {
            this.listener.transportProgressed(ByteBuffer.wrap(buffer, 0, length));
        }
        catch (TransferCancelledException e) {
            throw new WagonCancelledException(e);
        }
    }
}

