/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.eclipse.aether.transport.wagon;

import io.quarkus.launcher.shaded.javax.inject.Inject;
import io.quarkus.launcher.shaded.javax.inject.Named;
import io.quarkus.launcher.shaded.org.eclipse.aether.RepositorySystemSession;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.RemoteRepository;
import io.quarkus.launcher.shaded.org.eclipse.aether.spi.connector.transport.Transporter;
import io.quarkus.launcher.shaded.org.eclipse.aether.spi.connector.transport.TransporterFactory;
import io.quarkus.launcher.shaded.org.eclipse.aether.spi.locator.Service;
import io.quarkus.launcher.shaded.org.eclipse.aether.spi.locator.ServiceLocator;
import io.quarkus.launcher.shaded.org.eclipse.aether.transfer.NoTransporterException;
import io.quarkus.launcher.shaded.org.eclipse.aether.transport.wagon.WagonConfigurator;
import io.quarkus.launcher.shaded.org.eclipse.aether.transport.wagon.WagonProvider;
import io.quarkus.launcher.shaded.org.eclipse.aether.transport.wagon.WagonTransporter;

@Named(value="io.quarkus.launcher.shaded.wagon")
public final class WagonTransporterFactory
implements TransporterFactory,
Service {
    private WagonProvider wagonProvider;
    private WagonConfigurator wagonConfigurator;
    private float priority = -1.0f;

    public WagonTransporterFactory() {
    }

    @Inject
    WagonTransporterFactory(WagonProvider wagonProvider, WagonConfigurator wagonConfigurator) {
        this.setWagonProvider(wagonProvider);
        this.setWagonConfigurator(wagonConfigurator);
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.setWagonProvider(locator.getService(WagonProvider.class));
        this.setWagonConfigurator(locator.getService(WagonConfigurator.class));
    }

    public WagonTransporterFactory setWagonProvider(WagonProvider wagonProvider) {
        this.wagonProvider = wagonProvider;
        return this;
    }

    public WagonTransporterFactory setWagonConfigurator(WagonConfigurator wagonConfigurator) {
        this.wagonConfigurator = wagonConfigurator;
        return this;
    }

    @Override
    public float getPriority() {
        return this.priority;
    }

    public WagonTransporterFactory setPriority(float priority) {
        this.priority = priority;
        return this;
    }

    @Override
    public Transporter newInstance(RepositorySystemSession session, RemoteRepository repository) throws NoTransporterException {
        return new WagonTransporter(this.wagonProvider, this.wagonConfigurator, repository, session);
    }
}

