/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.eclipse.aether.util.filter;

import io.quarkus.launcher.shaded.org.eclipse.aether.graph.DependencyFilter;
import io.quarkus.launcher.shaded.org.eclipse.aether.util.filter.AndDependencyFilter;
import io.quarkus.launcher.shaded.org.eclipse.aether.util.filter.NotDependencyFilter;
import io.quarkus.launcher.shaded.org.eclipse.aether.util.filter.OrDependencyFilter;
import io.quarkus.launcher.shaded.org.eclipse.aether.util.filter.ScopeDependencyFilter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public final class DependencyFilterUtils {
    private DependencyFilterUtils() {
    }

    public static DependencyFilter notFilter(DependencyFilter filter) {
        return new NotDependencyFilter(filter);
    }

    public static DependencyFilter andFilter(DependencyFilter ... filters) {
        if (filters != null && filters.length == 1) {
            return filters[0];
        }
        return new AndDependencyFilter(filters);
    }

    public static DependencyFilter andFilter(Collection<DependencyFilter> filters) {
        if (filters != null && filters.size() == 1) {
            return filters.iterator().next();
        }
        return new AndDependencyFilter(filters);
    }

    public static DependencyFilter orFilter(DependencyFilter ... filters) {
        if (filters != null && filters.length == 1) {
            return filters[0];
        }
        return new OrDependencyFilter(filters);
    }

    public static DependencyFilter orFilter(Collection<DependencyFilter> filters) {
        if (filters != null && filters.size() == 1) {
            return filters.iterator().next();
        }
        return new OrDependencyFilter(filters);
    }

    public static DependencyFilter classpathFilter(String ... classpathTypes) {
        return DependencyFilterUtils.classpathFilter(classpathTypes != null ? Arrays.asList(classpathTypes) : null);
    }

    public static DependencyFilter classpathFilter(Collection<String> classpathTypes) {
        HashSet<String> types = new HashSet<String>();
        if (classpathTypes != null) {
            for (String classpathType : classpathTypes) {
                String[] tokens;
                for (String token : tokens = classpathType.split("io.quarkus.launcher.shaded.[+,]")) {
                    if ((token = token.trim()).length() <= 0) continue;
                    types.add(token);
                }
            }
        }
        HashSet<String> included = new HashSet<String>();
        for (String type : types) {
            if ("io.quarkus.launcher.shaded.compile".equals(type)) {
                Collections.addAll(included, "io.quarkus.launcher.shaded.compile", "io.quarkus.launcher.shaded.provided", "io.quarkus.launcher.shaded.system");
                continue;
            }
            if ("io.quarkus.launcher.shaded.runtime".equals(type)) {
                Collections.addAll(included, "io.quarkus.launcher.shaded.compile", "io.quarkus.launcher.shaded.runtime");
                continue;
            }
            if ("io.quarkus.launcher.shaded.test".equals(type)) {
                Collections.addAll(included, "io.quarkus.launcher.shaded.compile", "io.quarkus.launcher.shaded.provided", "io.quarkus.launcher.shaded.system", "io.quarkus.launcher.shaded.runtime", "io.quarkus.launcher.shaded.test");
                continue;
            }
            included.add(type);
        }
        HashSet<String> excluded = new HashSet<String>();
        Collections.addAll(excluded, "io.quarkus.launcher.shaded.compile", "io.quarkus.launcher.shaded.provided", "io.quarkus.launcher.shaded.system", "io.quarkus.launcher.shaded.runtime", "io.quarkus.launcher.shaded.test");
        excluded.removeAll(included);
        return new ScopeDependencyFilter(null, excluded);
    }
}

