/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.eclipse.aether.util.graph.transformer;

import io.quarkus.launcher.shaded.org.eclipse.aether.RepositoryException;
import io.quarkus.launcher.shaded.org.eclipse.aether.collection.DependencyGraphTransformationContext;
import io.quarkus.launcher.shaded.org.eclipse.aether.collection.DependencyGraphTransformer;
import io.quarkus.launcher.shaded.org.eclipse.aether.graph.Dependency;
import io.quarkus.launcher.shaded.org.eclipse.aether.graph.DependencyNode;

public final class JavaDependencyContextRefiner
implements DependencyGraphTransformer {
    @Override
    public DependencyNode transformGraph(DependencyNode node, DependencyGraphTransformationContext context) throws RepositoryException {
        String scope;
        String ctx = node.getRequestContext();
        if ("io.quarkus.launcher.shaded.project".equals(ctx) && (scope = this.getClasspathScope(node)) != null) {
            ctx = ctx + '/' + scope;
            node.setRequestContext(ctx);
        }
        for (DependencyNode child : node.getChildren()) {
            this.transformGraph(child, context);
        }
        return node;
    }

    private String getClasspathScope(DependencyNode node) {
        Dependency dependency = node.getDependency();
        if (dependency == null) {
            return null;
        }
        String scope = dependency.getScope();
        if ("io.quarkus.launcher.shaded.compile".equals(scope) || "io.quarkus.launcher.shaded.system".equals(scope) || "io.quarkus.launcher.shaded.provided".equals(scope)) {
            return "io.quarkus.launcher.shaded.compile";
        }
        if ("io.quarkus.launcher.shaded.runtime".equals(scope)) {
            return "io.quarkus.launcher.shaded.runtime";
        }
        if ("io.quarkus.launcher.shaded.test".equals(scope)) {
            return "io.quarkus.launcher.shaded.test";
        }
        return null;
    }
}

