/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.eclipse.aether.util.graph.transformer;

import io.quarkus.launcher.shaded.org.eclipse.aether.RepositoryException;
import io.quarkus.launcher.shaded.org.eclipse.aether.util.graph.transformer.ConflictResolver;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public final class JavaScopeSelector
extends ConflictResolver.ScopeSelector {
    @Override
    public void selectScope(ConflictResolver.ConflictContext context) throws RepositoryException {
        String scope = context.getWinner().getDependency().getScope();
        if (!"io.quarkus.launcher.shaded.system".equals(scope)) {
            scope = this.chooseEffectiveScope(context.getItems());
        }
        context.setScope(scope);
    }

    private String chooseEffectiveScope(Collection<ConflictResolver.ConflictItem> items) {
        HashSet<String> scopes = new HashSet<String>();
        for (ConflictResolver.ConflictItem item : items) {
            if (item.getDepth() <= 1) {
                return item.getDependency().getScope();
            }
            scopes.addAll(item.getScopes());
        }
        return this.chooseEffectiveScope((Set<String>)scopes);
    }

    private String chooseEffectiveScope(Set<String> scopes) {
        if (scopes.size() > 1) {
            scopes.remove("io.quarkus.launcher.shaded.system");
        }
        String effectiveScope = "io.quarkus.launcher.shaded.";
        if (scopes.size() == 1) {
            effectiveScope = scopes.iterator().next();
        } else if (scopes.contains("io.quarkus.launcher.shaded.compile")) {
            effectiveScope = "io.quarkus.launcher.shaded.compile";
        } else if (scopes.contains("io.quarkus.launcher.shaded.runtime")) {
            effectiveScope = "io.quarkus.launcher.shaded.runtime";
        } else if (scopes.contains("io.quarkus.launcher.shaded.provided")) {
            effectiveScope = "io.quarkus.launcher.shaded.provided";
        } else if (scopes.contains("io.quarkus.launcher.shaded.test")) {
            effectiveScope = "io.quarkus.launcher.shaded.test";
        }
        return effectiveScope;
    }
}

