/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.eclipse.aether.util.repository;

import io.quarkus.launcher.shaded.javax.net.ssl.HostnameVerifier;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.Authentication;
import io.quarkus.launcher.shaded.org.eclipse.aether.util.repository.ChainedAuthentication;
import io.quarkus.launcher.shaded.org.eclipse.aether.util.repository.ComponentAuthentication;
import io.quarkus.launcher.shaded.org.eclipse.aether.util.repository.SecretAuthentication;
import io.quarkus.launcher.shaded.org.eclipse.aether.util.repository.StringAuthentication;
import java.util.ArrayList;
import java.util.List;

public final class AuthenticationBuilder {
    private final List<Authentication> authentications = new ArrayList<Authentication>();

    public Authentication build() {
        if (this.authentications.isEmpty()) {
            return null;
        }
        if (this.authentications.size() == 1) {
            return this.authentications.get(0);
        }
        return new ChainedAuthentication(this.authentications);
    }

    public AuthenticationBuilder addUsername(String username) {
        return this.addString("io.quarkus.launcher.shaded.username", username);
    }

    public AuthenticationBuilder addPassword(String password) {
        return this.addSecret("io.quarkus.launcher.shaded.password", password);
    }

    public AuthenticationBuilder addPassword(char[] password) {
        return this.addSecret("io.quarkus.launcher.shaded.password", password);
    }

    public AuthenticationBuilder addNtlm(String workstation, String domain) {
        this.addString("io.quarkus.launcher.shaded.ntlm.workstation", workstation);
        return this.addString("io.quarkus.launcher.shaded.ntlm.domain", domain);
    }

    public AuthenticationBuilder addPrivateKey(String pathname, String passphrase) {
        if (pathname != null) {
            this.addString("io.quarkus.launcher.shaded.privateKey.path", pathname);
            this.addSecret("io.quarkus.launcher.shaded.privateKey.passphrase", passphrase);
        }
        return this;
    }

    public AuthenticationBuilder addPrivateKey(String pathname, char[] passphrase) {
        if (pathname != null) {
            this.addString("io.quarkus.launcher.shaded.privateKey.path", pathname);
            this.addSecret("io.quarkus.launcher.shaded.privateKey.passphrase", passphrase);
        }
        return this;
    }

    public AuthenticationBuilder addHostnameVerifier(HostnameVerifier verifier) {
        if (verifier != null) {
            this.authentications.add(new ComponentAuthentication("io.quarkus.launcher.shaded.ssl.hostnameVerifier", verifier));
        }
        return this;
    }

    public AuthenticationBuilder addString(String key, String value) {
        if (value != null) {
            this.authentications.add(new StringAuthentication(key, value));
        }
        return this;
    }

    public AuthenticationBuilder addSecret(String key, String value) {
        if (value != null) {
            this.authentications.add(new SecretAuthentication(key, value));
        }
        return this;
    }

    public AuthenticationBuilder addSecret(String key, char[] value) {
        if (value != null) {
            this.authentications.add(new SecretAuthentication(key, value));
        }
        return this;
    }

    public AuthenticationBuilder addCustom(Authentication authentication) {
        if (authentication != null) {
            this.authentications.add(authentication);
        }
        return this;
    }
}

