/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.eclipse.aether.util.repository;

import io.quarkus.launcher.shaded.org.eclipse.aether.repository.Proxy;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.ProxySelector;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.RemoteRepository;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public final class DefaultProxySelector
implements ProxySelector {
    private List<ProxyDef> proxies = new ArrayList<ProxyDef>();

    public DefaultProxySelector add(Proxy proxy, String nonProxyHosts) {
        Objects.requireNonNull(proxy, "io.quarkus.launcher.shaded.proxy cannot be null");
        this.proxies.add(new ProxyDef(proxy, nonProxyHosts));
        return this;
    }

    @Override
    public Proxy getProxy(RemoteRepository repository) {
        ProxyDef proxy2;
        HashMap<String, ProxyDef> candidates = new HashMap<String, ProxyDef>();
        String host = repository.getHost();
        for (ProxyDef proxy2 : this.proxies) {
            String key;
            if (proxy2.nonProxyHosts.isNonProxyHost(host) || candidates.containsKey(key = proxy2.proxy.getType().toLowerCase(Locale.ENGLISH))) continue;
            candidates.put(key, proxy2);
        }
        String protocol = repository.getProtocol().toLowerCase(Locale.ENGLISH);
        if ("io.quarkus.launcher.shaded.davs".equals(protocol)) {
            protocol = "io.quarkus.launcher.shaded.https";
        } else if ("io.quarkus.launcher.shaded.dav".equals(protocol)) {
            protocol = "io.quarkus.launcher.shaded.http";
        } else if (protocol.startsWith("io.quarkus.launcher.shaded.dav:")) {
            protocol = protocol.substring("io.quarkus.launcher.shaded.dav:".length());
        }
        proxy2 = (ProxyDef)candidates.get(protocol);
        if (proxy2 == null && "io.quarkus.launcher.shaded.https".equals(protocol)) {
            proxy2 = (ProxyDef)candidates.get("io.quarkus.launcher.shaded.http");
        }
        return proxy2 != null ? proxy2.proxy : null;
    }

    static class ProxyDef {
        final Proxy proxy;
        final NonProxyHosts nonProxyHosts;

        ProxyDef(Proxy proxy, String nonProxyHosts) {
            this.proxy = proxy;
            this.nonProxyHosts = new NonProxyHosts(nonProxyHosts);
        }
    }

    static class NonProxyHosts {
        private final Pattern[] patterns;

        NonProxyHosts(String nonProxyHosts) {
            ArrayList<Pattern> patterns = new ArrayList<Pattern>();
            if (nonProxyHosts != null) {
                StringTokenizer tokenizer = new StringTokenizer(nonProxyHosts, "io.quarkus.launcher.shaded.|");
                while (tokenizer.hasMoreTokens()) {
                    String pattern = tokenizer.nextToken();
                    pattern = pattern.replace("io.quarkus.launcher.shaded..", "io.quarkus.launcher.shaded.\\.").replace("io.quarkus.launcher.shaded.*", "io.quarkus.launcher.shaded..*");
                    patterns.add(Pattern.compile(pattern, 2));
                }
            }
            this.patterns = patterns.toArray(new Pattern[patterns.size()]);
        }

        boolean isNonProxyHost(String host) {
            if (host != null) {
                for (Pattern pattern : this.patterns) {
                    if (!pattern.matcher(host).matches()) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

