/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.eclipse.aether.util.version;

import io.quarkus.launcher.shaded.org.eclipse.aether.util.version.GenericVersion;
import io.quarkus.launcher.shaded.org.eclipse.aether.version.InvalidVersionSpecificationException;
import io.quarkus.launcher.shaded.org.eclipse.aether.version.Version;
import io.quarkus.launcher.shaded.org.eclipse.aether.version.VersionRange;
import java.util.Objects;

final class GenericVersionRange
implements VersionRange {
    private final VersionRange.Bound lowerBound;
    private final VersionRange.Bound upperBound;

    GenericVersionRange(String range) throws InvalidVersionSpecificationException {
        Version upperBound;
        Version lowerBound;
        boolean upperBoundInclusive;
        boolean lowerBoundInclusive;
        String process = range;
        if (range.startsWith("io.quarkus.launcher.shaded.[")) {
            lowerBoundInclusive = true;
        } else if (range.startsWith("io.quarkus.launcher.shaded.(")) {
            lowerBoundInclusive = false;
        } else {
            throw new InvalidVersionSpecificationException(range, "io.quarkus.launcher.shaded.Invalid version range " + range + "io.quarkus.launcher.shaded., a range must start with either [ or (");
        }
        if (range.endsWith("io.quarkus.launcher.shaded.]")) {
            upperBoundInclusive = true;
        } else if (range.endsWith("io.quarkus.launcher.shaded.)")) {
            upperBoundInclusive = false;
        } else {
            throw new InvalidVersionSpecificationException(range, "io.quarkus.launcher.shaded.Invalid version range " + range + "io.quarkus.launcher.shaded., a range must end with either [ or (");
        }
        process = process.substring(1, process.length() - 1);
        int index = process.indexOf("io.quarkus.launcher.shaded.,");
        if (index < 0) {
            if (!lowerBoundInclusive || !upperBoundInclusive) {
                throw new InvalidVersionSpecificationException(range, "io.quarkus.launcher.shaded.Invalid version range " + range + "io.quarkus.launcher.shaded., single version must be surrounded by []");
            }
            String version = process.trim();
            if (version.endsWith("io.quarkus.launcher.shaded..*")) {
                String prefix = version.substring(0, version.length() - 1);
                lowerBound = this.parse(prefix + "io.quarkus.launcher.shaded.min");
                upperBound = this.parse(prefix + "io.quarkus.launcher.shaded.max");
            } else {
                upperBound = lowerBound = this.parse(version);
            }
        } else {
            String parsedLowerBound = process.substring(0, index).trim();
            String parsedUpperBound = process.substring(index + 1).trim();
            if (parsedUpperBound.contains("io.quarkus.launcher.shaded.,")) {
                throw new InvalidVersionSpecificationException(range, "io.quarkus.launcher.shaded.Invalid version range " + range + "io.quarkus.launcher.shaded., bounds may not contain additional ','");
            }
            lowerBound = parsedLowerBound.length() > 0 ? this.parse(parsedLowerBound) : null;
            Version version = upperBound = parsedUpperBound.length() > 0 ? this.parse(parsedUpperBound) : null;
            if (upperBound != null && lowerBound != null && upperBound.compareTo(lowerBound) < 0) {
                throw new InvalidVersionSpecificationException(range, "io.quarkus.launcher.shaded.Invalid version range " + range + "io.quarkus.launcher.shaded., lower bound must not be greater than upper bound");
            }
        }
        this.lowerBound = lowerBound != null ? new VersionRange.Bound(lowerBound, lowerBoundInclusive) : null;
        this.upperBound = upperBound != null ? new VersionRange.Bound(upperBound, upperBoundInclusive) : null;
    }

    private Version parse(String version) {
        return new GenericVersion(version);
    }

    @Override
    public VersionRange.Bound getLowerBound() {
        return this.lowerBound;
    }

    @Override
    public VersionRange.Bound getUpperBound() {
        return this.upperBound;
    }

    @Override
    public boolean containsVersion(Version version) {
        int comparison;
        if (this.lowerBound != null) {
            comparison = this.lowerBound.getVersion().compareTo(version);
            if (comparison == 0 && !this.lowerBound.isInclusive()) {
                return false;
            }
            if (comparison > 0) {
                return false;
            }
        }
        if (this.upperBound != null) {
            comparison = this.upperBound.getVersion().compareTo(version);
            if (comparison == 0 && !this.upperBound.isInclusive()) {
                return false;
            }
            if (comparison < 0) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        GenericVersionRange that = (GenericVersionRange)obj;
        return Objects.equals(this.upperBound, that.upperBound) && Objects.equals(this.lowerBound, that.lowerBound);
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + GenericVersionRange.hash(this.upperBound);
        hash = hash * 31 + GenericVersionRange.hash(this.lowerBound);
        return hash;
    }

    private static int hash(Object obj) {
        return obj != null ? obj.hashCode() : 0;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(64);
        if (this.lowerBound != null) {
            buffer.append(this.lowerBound.isInclusive() ? (char)'[' : '(');
            buffer.append(this.lowerBound.getVersion());
        } else {
            buffer.append('(');
        }
        buffer.append(',');
        if (this.upperBound != null) {
            buffer.append(this.upperBound.getVersion());
            buffer.append(this.upperBound.isInclusive() ? (char)']' : ')');
        } else {
            buffer.append(')');
        }
        return buffer.toString();
    }
}

