/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.eclipse.aether.util.version;

import io.quarkus.launcher.shaded.org.eclipse.aether.util.version.GenericVersion;
import io.quarkus.launcher.shaded.org.eclipse.aether.util.version.GenericVersionConstraint;
import io.quarkus.launcher.shaded.org.eclipse.aether.util.version.GenericVersionRange;
import io.quarkus.launcher.shaded.org.eclipse.aether.util.version.UnionVersionRange;
import io.quarkus.launcher.shaded.org.eclipse.aether.version.InvalidVersionSpecificationException;
import io.quarkus.launcher.shaded.org.eclipse.aether.version.Version;
import io.quarkus.launcher.shaded.org.eclipse.aether.version.VersionConstraint;
import io.quarkus.launcher.shaded.org.eclipse.aether.version.VersionRange;
import io.quarkus.launcher.shaded.org.eclipse.aether.version.VersionScheme;
import java.util.ArrayList;

public final class GenericVersionScheme
implements VersionScheme {
    @Override
    public Version parseVersion(String version) throws InvalidVersionSpecificationException {
        return new GenericVersion(version);
    }

    @Override
    public VersionRange parseVersionRange(String range) throws InvalidVersionSpecificationException {
        return new GenericVersionRange(range);
    }

    @Override
    public VersionConstraint parseVersionConstraint(String constraint) throws InvalidVersionSpecificationException {
        ArrayList<VersionRange> ranges = new ArrayList<VersionRange>();
        String process = constraint;
        while (process.startsWith("io.quarkus.launcher.shaded.[") || process.startsWith("io.quarkus.launcher.shaded.(")) {
            int index2;
            int index1 = process.indexOf(41);
            int index = index2 = process.indexOf(93);
            if (index2 < 0 || index1 >= 0 && index1 < index2) {
                index = index1;
            }
            if (index < 0) {
                throw new InvalidVersionSpecificationException(constraint, "io.quarkus.launcher.shaded.Unbounded version range " + constraint);
            }
            VersionRange range = this.parseVersionRange(process.substring(0, index + 1));
            ranges.add(range);
            if ((process = process.substring(index + 1).trim()).length() <= 0 || !process.startsWith("io.quarkus.launcher.shaded.,")) continue;
            process = process.substring(1).trim();
        }
        if (process.length() > 0 && !ranges.isEmpty()) {
            throw new InvalidVersionSpecificationException(constraint, "io.quarkus.launcher.shaded.Invalid version range " + constraint + "io.quarkus.launcher.shaded., expected [ or ( but got " + process);
        }
        GenericVersionConstraint result = ranges.isEmpty() ? new GenericVersionConstraint(this.parseVersion(constraint)) : new GenericVersionConstraint(UnionVersionRange.from(ranges));
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj != null && this.getClass().equals(obj.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

