/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.eclipse.sisu.bean;

import io.quarkus.launcher.shaded.com.google.inject.ProvisionException;
import io.quarkus.launcher.shaded.com.google.inject.TypeLiteral;
import io.quarkus.launcher.shaded.com.google.inject.spi.TypeEncounter;
import io.quarkus.launcher.shaded.com.google.inject.spi.TypeListener;
import io.quarkus.launcher.shaded.javax.inject.Inject;
import io.quarkus.launcher.shaded.org.eclipse.sisu.bean.BeanBinder;
import io.quarkus.launcher.shaded.org.eclipse.sisu.bean.BeanInjector;
import io.quarkus.launcher.shaded.org.eclipse.sisu.bean.BeanProperties;
import io.quarkus.launcher.shaded.org.eclipse.sisu.bean.BeanProperty;
import io.quarkus.launcher.shaded.org.eclipse.sisu.bean.PropertyBinder;
import io.quarkus.launcher.shaded.org.eclipse.sisu.bean.PropertyBinding;
import java.util.ArrayList;
import java.util.HashSet;

public final class BeanListener
implements TypeListener {
    private final BeanBinder beanBinder;

    public BeanListener(BeanBinder beanBinder) {
        this.beanBinder = beanBinder;
    }

    public <B> void hear(TypeLiteral<B> type, TypeEncounter<B> encounter) {
        PropertyBinder propertyBinder = this.beanBinder.bindBean(type, encounter);
        if (propertyBinder == null) {
            return;
        }
        ArrayList<PropertyBinding> bindings = new ArrayList<PropertyBinding>();
        HashSet<String> visited = new HashSet<String>();
        for (BeanProperty<Object> property : new BeanProperties(type.getRawType())) {
            String name;
            if (property.getAnnotation(Inject.class) != null || property.getAnnotation(io.quarkus.launcher.shaded.com.google.inject.Inject.class) != null || !visited.add(name = property.getName())) continue;
            try {
                PropertyBinding binding = propertyBinder.bindProperty(property);
                if (binding == PropertyBinder.LAST_BINDING) break;
                if (binding != null) {
                    bindings.add(binding);
                    continue;
                }
                visited.remove(name);
            }
            catch (RuntimeException e) {
                encounter.addError(new ProvisionException("io.quarkus.launcher.shaded.Error binding: " + property, e));
            }
        }
        if (bindings.size() > 0) {
            encounter.register(new BeanInjector(bindings));
        }
    }
}

