/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.eclipse.sisu.inject;

import io.quarkus.launcher.shaded.com.google.inject.Injector;
import io.quarkus.launcher.shaded.com.google.inject.Key;
import io.quarkus.launcher.shaded.com.google.inject.Singleton;
import io.quarkus.launcher.shaded.com.google.inject.TypeLiteral;
import io.quarkus.launcher.shaded.javax.inject.Inject;
import io.quarkus.launcher.shaded.org.eclipse.sisu.BeanEntry;
import io.quarkus.launcher.shaded.org.eclipse.sisu.Mediator;
import io.quarkus.launcher.shaded.org.eclipse.sisu.inject.BindingPublisher;
import io.quarkus.launcher.shaded.org.eclipse.sisu.inject.DefaultRankingFunction;
import io.quarkus.launcher.shaded.org.eclipse.sisu.inject.ImplicitBindings;
import io.quarkus.launcher.shaded.org.eclipse.sisu.inject.InjectorBindings;
import io.quarkus.launcher.shaded.org.eclipse.sisu.inject.LocatedBeans;
import io.quarkus.launcher.shaded.org.eclipse.sisu.inject.Logs;
import io.quarkus.launcher.shaded.org.eclipse.sisu.inject.MildConcurrentValues;
import io.quarkus.launcher.shaded.org.eclipse.sisu.inject.MutableBeanLocator;
import io.quarkus.launcher.shaded.org.eclipse.sisu.inject.RankedBindings;
import io.quarkus.launcher.shaded.org.eclipse.sisu.inject.RankedSequence;
import io.quarkus.launcher.shaded.org.eclipse.sisu.inject.TypeArguments;
import io.quarkus.launcher.shaded.org.eclipse.sisu.inject.WatchedBeans;
import io.quarkus.launcher.shaded.org.eclipse.sisu.inject.Weak;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

@Singleton
public final class DefaultBeanLocator
implements MutableBeanLocator {
    private final RankedSequence<BindingPublisher> publishers = new RankedSequence();
    private final ConcurrentMap<Long, RankedBindings> cachedBindings = Weak.concurrentValues(256, 8);
    private final Map<WatchedBeans, Object> cachedWatchers = Weak.values();
    private final ImplicitBindings implicitBindings = new ImplicitBindings(this.publishers);
    private final Long[] typeIdHolder = new Long[1];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<BeanEntry> locate(Key key) {
        TypeLiteral type = key.getTypeLiteral();
        RankedBindings bindings = this.fetchBindings(type, null);
        if (bindings == null) {
            ConcurrentMap<Long, RankedBindings> concurrentMap = this.cachedBindings;
            synchronized (concurrentMap) {
                bindings = this.fetchBindings(type, this.typeIdHolder);
                if (bindings == null) {
                    bindings = new RankedBindings(type, this.publishers);
                    this.cachedBindings.put(this.typeIdHolder[0], bindings);
                }
            }
        }
        boolean isImplicit = key.getAnnotationType() == null && TypeArguments.isImplicit(type);
        return new LocatedBeans(key, bindings, isImplicit ? this.implicitBindings : null);
    }

    public synchronized void watch(Key key, Mediator mediator, Object watcher) {
        WatchedBeans beans = new WatchedBeans(key, mediator, watcher);
        for (BindingPublisher p : this.publishers()) {
            p.subscribe(beans);
        }
        this.cachedWatchers.put(beans, watcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean add(BindingPublisher publisher) {
        if (this.publishers.contains(publisher)) {
            return false;
        }
        Logs.trace("io.quarkus.launcher.shaded.Add publisher: {}", publisher, null);
        ConcurrentMap<Long, RankedBindings> concurrentMap = this.cachedBindings;
        synchronized (concurrentMap) {
            int rank = publisher.maxBindingRank();
            this.publishers.insert(publisher, rank);
            for (RankedBindings bindings : this.cachedBindings.values()) {
                bindings.add(publisher, rank);
            }
        }
        for (WatchedBeans beans : new ArrayList<WatchedBeans>(this.cachedWatchers.keySet())) {
            publisher.subscribe(beans);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean remove(BindingPublisher publisher) {
        BindingPublisher oldPublisher;
        ConcurrentMap<Long, RankedBindings> concurrentMap = this.cachedBindings;
        synchronized (concurrentMap) {
            block6: {
                oldPublisher = this.publishers.remove(publisher);
                if (oldPublisher != null) break block6;
                return false;
            }
            Logs.trace("io.quarkus.launcher.shaded.Remove publisher: {}", oldPublisher, null);
            for (RankedBindings bindings : this.cachedBindings.values()) {
                bindings.remove(oldPublisher);
            }
        }
        for (WatchedBeans beans : this.cachedWatchers.keySet()) {
            oldPublisher.unsubscribe(beans);
        }
        ((MildConcurrentValues)this.cachedBindings).compact();
        return true;
    }

    @Override
    public Iterable<BindingPublisher> publishers() {
        return this.publishers.snapshot();
    }

    @Override
    public synchronized void clear() {
        for (BindingPublisher p : this.publishers()) {
            this.remove(p);
        }
    }

    @Override
    public void add(Injector injector, int rank) {
        this.add(new InjectorBindings(injector, new DefaultRankingFunction(rank)));
    }

    @Override
    public void remove(Injector injector) {
        this.remove(new InjectorBindings(injector, null));
    }

    private RankedBindings fetchBindings(TypeLiteral type, Long[] idReturn) {
        RankedBindings result;
        int loaderHash = System.identityHashCode(type.getRawType().getClassLoader());
        long id = (long)type.hashCode() << 32 | 0xFFFFFFFFL & (long)loaderHash;
        while ((result = (RankedBindings)this.cachedBindings.get(id)) != null && !type.equals(result.type())) {
            ++id;
        }
        if (idReturn != null) {
            idReturn[0] = id;
        }
        return result;
    }

    @Inject
    void autoPublish(Injector injector) {
        DefaultBeanLocator.staticAutoPublish(this, injector);
    }

    @Inject
    static void staticAutoPublish(MutableBeanLocator locator, Injector injector) {
        locator.add(new InjectorBindings(injector));
    }
}

