/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.eclipse.sisu.inject;

import io.quarkus.launcher.shaded.com.google.inject.Binding;
import io.quarkus.launcher.shaded.javax.inject.Inject;
import io.quarkus.launcher.shaded.org.eclipse.sisu.Priority;
import io.quarkus.launcher.shaded.org.eclipse.sisu.inject.QualifyingStrategy;
import io.quarkus.launcher.shaded.org.eclipse.sisu.inject.RankingFunction;
import io.quarkus.launcher.shaded.org.eclipse.sisu.inject.Sources;

public final class DefaultRankingFunction
implements RankingFunction {
    private final int primaryRank;

    public DefaultRankingFunction(int primaryRank) {
        if (primaryRank < 0) {
            throw new IllegalArgumentException("io.quarkus.launcher.shaded.Primary rank must be zero or more");
        }
        this.primaryRank = primaryRank;
    }

    @Inject
    public DefaultRankingFunction() {
        this(0);
    }

    @Override
    public int maxRank() {
        return Integer.MAX_VALUE;
    }

    @Override
    public <T> int rank(Binding<T> binding) {
        Priority priority = Sources.getAnnotation(binding, Priority.class);
        if (priority != null) {
            return priority.value();
        }
        if (QualifyingStrategy.DEFAULT_QUALIFIER.equals(QualifyingStrategy.qualify(binding.getKey()))) {
            return this.primaryRank;
        }
        return this.primaryRank + Integer.MIN_VALUE;
    }
}

