/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.eclipse.sisu.inject;

import io.quarkus.launcher.shaded.com.google.inject.Binding;
import io.quarkus.launcher.shaded.com.google.inject.servlet.InstanceFilterBinding;
import io.quarkus.launcher.shaded.com.google.inject.servlet.InstanceServletBinding;
import io.quarkus.launcher.shaded.com.google.inject.servlet.LinkedFilterBinding;
import io.quarkus.launcher.shaded.com.google.inject.servlet.LinkedServletBinding;
import io.quarkus.launcher.shaded.com.google.inject.servlet.ServletModuleTargetVisitor;
import io.quarkus.launcher.shaded.com.google.inject.spi.BindingTargetVisitor;
import io.quarkus.launcher.shaded.com.google.inject.spi.ConstructorBinding;
import io.quarkus.launcher.shaded.com.google.inject.spi.DefaultBindingTargetVisitor;
import io.quarkus.launcher.shaded.com.google.inject.spi.ExposedBinding;
import io.quarkus.launcher.shaded.com.google.inject.spi.InstanceBinding;
import io.quarkus.launcher.shaded.com.google.inject.spi.LinkedKeyBinding;
import io.quarkus.launcher.shaded.com.google.inject.spi.ProviderInstanceBinding;
import io.quarkus.launcher.shaded.com.google.inject.spi.UntargettedBinding;
import io.quarkus.launcher.shaded.javax.inject.Provider;
import io.quarkus.launcher.shaded.org.eclipse.sisu.Description;
import io.quarkus.launcher.shaded.org.eclipse.sisu.Priority;
import io.quarkus.launcher.shaded.org.eclipse.sisu.inject.DeferredProvider;
import io.quarkus.launcher.shaded.org.eclipse.sisu.inject.DescriptionSource;
import io.quarkus.launcher.shaded.org.eclipse.sisu.inject.Guice4;
import io.quarkus.launcher.shaded.org.eclipse.sisu.inject.PrioritySource;
import java.lang.annotation.Annotation;

final class Implementations {
    private static final boolean HAS_GUICE_SERVLET;
    private static final boolean HAS_JSR250_PRIORITY;

    static {
        boolean hasJsr250Priority;
        boolean hasGuiceServlet;
        try {
            hasGuiceServlet = BindingTargetVisitor.class.isInstance(ServletFinder.THIS);
        }
        catch (LinkageError linkageError) {
            hasGuiceServlet = false;
        }
        HAS_GUICE_SERVLET = hasGuiceServlet;
        try {
            hasJsr250Priority = io.quarkus.launcher.shaded.javax.annotation.Priority.class.isAnnotation();
        }
        catch (LinkageError linkageError) {
            hasJsr250Priority = false;
        }
        HAS_JSR250_PRIORITY = hasJsr250Priority;
    }

    private Implementations() {
    }

    public static Class<?> find(Binding<?> binding) {
        return binding.acceptTargetVisitor(ClassFinder.THIS);
    }

    public static <T extends Annotation> T getAnnotation(Binding<?> binding, Class<T> annotationType) {
        boolean isPriority = Priority.class.equals(annotationType);
        Class<?> implementation = binding.acceptTargetVisitor(HAS_GUICE_SERVLET && isPriority ? ServletFinder.THIS : ClassFinder.THIS);
        T annotation = null;
        if (implementation != null && (annotation = (T)implementation.getAnnotation(annotationType)) == null) {
            if (HAS_JSR250_PRIORITY && isPriority) {
                annotation = Implementations.adaptJsr250(binding, implementation);
            } else if (Description.class.equals(annotationType)) {
                annotation = Implementations.adaptLegacy(binding, implementation);
            }
        }
        return annotation;
    }

    private static <T extends Annotation> T adaptJsr250(Binding<?> binding, Class<?> clazz) {
        io.quarkus.launcher.shaded.javax.annotation.Priority jsr250 = clazz.getAnnotation(io.quarkus.launcher.shaded.javax.annotation.Priority.class);
        return (T)(jsr250 != null ? new PrioritySource(binding.getSource(), jsr250.value()) : null);
    }

    private static <T extends Annotation> T adaptLegacy(Binding<?> binding, Class<?> clazz) {
        io.quarkus.launcher.shaded.org.sonatype.inject.Description legacy = clazz.getAnnotation(io.quarkus.launcher.shaded.org.sonatype.inject.Description.class);
        return (T)(legacy != null ? new DescriptionSource(binding.getSource(), legacy.value()) : null);
    }

    static class ClassFinder
    extends DefaultBindingTargetVisitor<Object, Class<?>> {
        static final BindingTargetVisitor<Object, Class<?>> THIS = new ClassFinder();

        ClassFinder() {
        }

        @Override
        public Class<?> visit(UntargettedBinding<?> binding) {
            return binding.getKey().getTypeLiteral().getRawType();
        }

        @Override
        public Class<?> visit(LinkedKeyBinding<?> binding) {
            return binding.getLinkedKey().getTypeLiteral().getRawType();
        }

        @Override
        public Class<?> visit(ConstructorBinding<?> binding) {
            return binding.getConstructor().getDeclaringType().getRawType();
        }

        @Override
        public Class<?> visit(InstanceBinding<?> binding) {
            return binding.getInstance().getClass();
        }

        @Override
        public Class<?> visit(ProviderInstanceBinding<?> binding) {
            Provider<?> provider = Guice4.getProviderInstance(binding);
            if (provider instanceof DeferredProvider) {
                try {
                    return ((DeferredProvider)provider).getImplementationClass().load();
                }
                catch (TypeNotPresentException typeNotPresentException) {}
            }
            return null;
        }

        @Override
        public Class<?> visit(ExposedBinding<?> binding) {
            return (Class)binding.getPrivateElements().getInjector().getBinding(binding.getKey()).acceptTargetVisitor(this);
        }
    }

    static final class ServletFinder
    extends ClassFinder
    implements ServletModuleTargetVisitor<Object, Class<?>> {
        static final BindingTargetVisitor<Object, Class<?>> THIS = new ServletFinder();

        ServletFinder() {
        }

        public Class<?> visit(InstanceFilterBinding binding) {
            return binding.getFilterInstance().getClass();
        }

        public Class<?> visit(InstanceServletBinding binding) {
            return binding.getServletInstance().getClass();
        }

        public Class<?> visit(LinkedFilterBinding binding) {
            return binding.getLinkedKey().getTypeLiteral().getRawType();
        }

        public Class<?> visit(LinkedServletBinding binding) {
            return binding.getLinkedKey().getTypeLiteral().getRawType();
        }
    }
}

