/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.eclipse.sisu.inject;

import io.quarkus.launcher.shaded.com.google.inject.Binding;
import io.quarkus.launcher.shaded.com.google.inject.Injector;
import io.quarkus.launcher.shaded.com.google.inject.Key;
import io.quarkus.launcher.shaded.com.google.inject.TypeLiteral;
import io.quarkus.launcher.shaded.org.eclipse.sisu.Hidden;
import io.quarkus.launcher.shaded.org.eclipse.sisu.inject.BindingPublisher;
import io.quarkus.launcher.shaded.org.eclipse.sisu.inject.InjectorBindings;
import io.quarkus.launcher.shaded.org.eclipse.sisu.inject.Logs;
import io.quarkus.launcher.shaded.org.eclipse.sisu.inject.Sources;
import io.quarkus.launcher.shaded.org.eclipse.sisu.inject.TypeArguments;

final class ImplicitBindings {
    private final Iterable<BindingPublisher> publishers;

    ImplicitBindings(Iterable<BindingPublisher> publishers) {
        this.publishers = publishers;
    }

    public <T> Binding<T> get(TypeLiteral<T> type) {
        Key<T> implicitKey = TypeArguments.implicitKey(type.getRawType());
        for (BindingPublisher p : this.publishers) {
            Injector i;
            Binding<?> binding;
            if (!(p instanceof InjectorBindings) || (binding = (i = ((InjectorBindings)p).getInjector()).getBindings().get(implicitKey)) == null) continue;
            Logs.trace("io.quarkus.launcher.shaded.Using implicit binding: {} from: <>", binding, i);
            return binding;
        }
        Key<T> justInTimeKey = Key.get(type);
        for (BindingPublisher p : this.publishers) {
            if (!(p instanceof InjectorBindings)) continue;
            Injector i = ((InjectorBindings)p).getInjector();
            try {
                Binding<T> binding = i.getBinding(justInTimeKey);
                if (Sources.getAnnotation(binding, Hidden.class) != null) continue;
                Logs.trace("io.quarkus.launcher.shaded.Using just-in-time binding: {} from: <>", binding, i);
                return binding;
            }
            catch (RuntimeException e) {
                Logs.trace("io.quarkus.launcher.shaded.Problem with just-in-time binding: {}", justInTimeKey, e);
            }
            catch (LinkageError e) {
                Logs.trace("io.quarkus.launcher.shaded.Problem with just-in-time binding: {}", justInTimeKey, e);
            }
        }
        return null;
    }
}

