/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.eclipse.sisu.inject;

import io.quarkus.launcher.shaded.com.google.inject.Binding;
import io.quarkus.launcher.shaded.com.google.inject.Key;
import io.quarkus.launcher.shaded.com.google.inject.TypeLiteral;
import io.quarkus.launcher.shaded.org.eclipse.sisu.BeanEntry;
import io.quarkus.launcher.shaded.org.eclipse.sisu.Mediator;
import io.quarkus.launcher.shaded.org.eclipse.sisu.inject.BeanCache;
import io.quarkus.launcher.shaded.org.eclipse.sisu.inject.BindingSubscriber;
import io.quarkus.launcher.shaded.org.eclipse.sisu.inject.Logs;
import io.quarkus.launcher.shaded.org.eclipse.sisu.inject.QualifyingStrategy;
import java.lang.annotation.Annotation;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;

final class WatchedBeans<Q extends Annotation, T, W>
implements BindingSubscriber<T> {
    private final BeanCache<Q, T> beans = new BeanCache();
    private final Key<T> key;
    private final Mediator<Q, T, W> mediator;
    private final QualifyingStrategy strategy;
    private final Reference<W> watcherRef;

    WatchedBeans(Key<T> key, Mediator<Q, T, W> mediator, W watcher) {
        this.key = key;
        this.mediator = mediator;
        this.strategy = QualifyingStrategy.selectFor(key);
        this.watcherRef = new WeakReference<W>(watcher);
    }

    @Override
    public TypeLiteral<T> type() {
        return this.key.getTypeLiteral();
    }

    @Override
    public void add(Binding<T> binding, int rank) {
        W watcher;
        Annotation qualifier = this.strategy.qualifies(this.key, binding);
        if (qualifier != null && (watcher = this.watcherRef.get()) != null) {
            BeanEntry<Annotation, T> bean = this.beans.create(qualifier, binding, rank);
            try {
                this.mediator.add(bean, watcher);
            }
            catch (Throwable e) {
                Logs.catchThrowable(e);
                Logs.warn("io.quarkus.launcher.shaded.Problem adding: <> to: " + this.detail(watcher), bean, e);
            }
        }
    }

    @Override
    public void remove(Binding<T> binding) {
        W watcher;
        BeanEntry<Q, T> bean = this.beans.remove(binding);
        if (bean != null && (watcher = this.watcherRef.get()) != null) {
            try {
                this.mediator.remove(bean, watcher);
            }
            catch (Throwable e) {
                Logs.catchThrowable(e);
                Logs.warn("io.quarkus.launcher.shaded.Problem removing: <> from: " + this.detail(watcher), bean, e);
            }
        }
    }

    @Override
    public Iterable<Binding<T>> bindings() {
        return this.beans.bindings();
    }

    private String detail(Object watcher) {
        return String.valueOf(Logs.identityToString(watcher)) + "io.quarkus.launcher.shaded. via: " + Logs.identityToString(this.mediator);
    }
}

