/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.eclipse.sisu.launch;

import io.quarkus.launcher.shaded.com.google.inject.Binder;
import io.quarkus.launcher.shaded.com.google.inject.Module;
import io.quarkus.launcher.shaded.org.eclipse.sisu.inject.MutableBeanLocator;
import io.quarkus.launcher.shaded.org.eclipse.sisu.launch.SisuExtensions;
import io.quarkus.launcher.shaded.org.eclipse.sisu.space.BeanScanning;
import io.quarkus.launcher.shaded.org.eclipse.sisu.space.BundleClassSpace;
import io.quarkus.launcher.shaded.org.eclipse.sisu.space.ClassSpace;
import io.quarkus.launcher.shaded.org.eclipse.sisu.space.SpaceModule;
import io.quarkus.launcher.shaded.org.eclipse.sisu.wire.ParameterKeys;
import io.quarkus.launcher.shaded.org.eclipse.sisu.wire.WireModule;
import io.quarkus.launcher.shaded.org.osgi.framework.Bundle;
import io.quarkus.launcher.shaded.org.osgi.framework.BundleContext;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class BundleModule
implements Module {
    protected final BundleClassSpace space;
    protected final SisuExtensions extensions;
    protected final MutableBeanLocator locator;

    public BundleModule(Bundle bundle, MutableBeanLocator locator) {
        this.space = new BundleClassSpace(bundle);
        this.extensions = SisuExtensions.local(this.space);
        this.locator = locator;
    }

    @Override
    public void configure(Binder binder) {
        new WireModule(this.modules()).with(this.extensions).configure(binder);
    }

    protected Map<?, ?> getProperties() {
        return System.getProperties();
    }

    protected List<Module> modules() {
        return Arrays.asList(this.extensionsModule(), this.contextModule(), this.spaceModule());
    }

    protected Module extensionsModule() {
        return new Module(){

            @Override
            public void configure(Binder binder) {
                BundleModule.this.extensions.install(binder, Bundle.class, BundleModule.this.space.getBundle());
            }
        };
    }

    protected Module contextModule() {
        return new Module(){

            @Override
            public void configure(Binder binder) {
                binder.bind(MutableBeanLocator.class).toInstance(BundleModule.this.locator);
                Bundle bundle = BundleModule.this.space.getBundle();
                binder.bind(ParameterKeys.PROPERTIES).toInstance(BundleModule.this.getProperties());
                binder.bind(BundleContext.class).toInstance(bundle.getBundleContext());
            }
        };
    }

    protected Module spaceModule() {
        return new SpaceModule((ClassSpace)this.space, BeanScanning.select(this.getProperties())).with(this.extensions);
    }
}

