/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.eclipse.sisu.launch;

import io.quarkus.launcher.shaded.com.google.inject.Binder;
import io.quarkus.launcher.shaded.com.google.inject.Guice;
import io.quarkus.launcher.shaded.com.google.inject.Key;
import io.quarkus.launcher.shaded.com.google.inject.Module;
import io.quarkus.launcher.shaded.com.google.inject.name.Names;
import io.quarkus.launcher.shaded.javax.inject.Inject;
import io.quarkus.launcher.shaded.junit.framework.TestCase;
import io.quarkus.launcher.shaded.org.eclipse.sisu.inject.MutableBeanLocator;
import io.quarkus.launcher.shaded.org.eclipse.sisu.space.BeanScanning;
import io.quarkus.launcher.shaded.org.eclipse.sisu.space.ClassSpace;
import io.quarkus.launcher.shaded.org.eclipse.sisu.space.SpaceModule;
import io.quarkus.launcher.shaded.org.eclipse.sisu.space.URLClassSpace;
import io.quarkus.launcher.shaded.org.eclipse.sisu.wire.ParameterKeys;
import io.quarkus.launcher.shaded.org.eclipse.sisu.wire.WireModule;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public abstract class InjectedTestCase
extends TestCase
implements Module {
    private String basedir;
    @Inject
    private MutableBeanLocator locator;

    protected void setUp() throws Exception {
        Guice.createInjector(new WireModule(new SetUpModule(), this.spaceModule()));
    }

    protected void tearDown() throws Exception {
        this.locator.clear();
    }

    public SpaceModule spaceModule() {
        return new SpaceModule(this.space(), this.scanning());
    }

    public ClassSpace space() {
        return new URLClassSpace(this.getClass().getClassLoader());
    }

    public BeanScanning scanning() {
        return BeanScanning.CACHE;
    }

    @Override
    public void configure(Binder binder) {
    }

    public void configure(Properties properties) {
    }

    public final <T> T lookup(Class<T> type) {
        return this.lookup(Key.get(type));
    }

    public final <T> T lookup(Class<T> type, String name) {
        return this.lookup(type, Names.named(name));
    }

    public final <T> T lookup(Class<T> type, Class<? extends Annotation> qualifier) {
        return this.lookup(Key.get(type, qualifier));
    }

    public final <T> T lookup(Class<T> type, Annotation qualifier) {
        return this.lookup(Key.get(type, qualifier));
    }

    public final String getBasedir() {
        if (this.basedir == null) {
            this.basedir = System.getProperty("io.quarkus.launcher.shaded.basedir", new File("io.quarkus.launcher.shaded.").getAbsolutePath());
        }
        return this.basedir;
    }

    private <T> T lookup(Key<T> key) {
        Iterator i = this.locator.locate(key).iterator();
        return i.hasNext() ? (T)((Map.Entry)i.next()).getValue() : null;
    }

    final class SetUpModule
    implements Module {
        SetUpModule() {
        }

        @Override
        public void configure(Binder binder) {
            binder.install(InjectedTestCase.this);
            Properties properties = new Properties();
            properties.put("io.quarkus.launcher.shaded.basedir", InjectedTestCase.this.getBasedir());
            InjectedTestCase.this.configure(properties);
            binder.bind(ParameterKeys.PROPERTIES).toInstance(properties);
            binder.requestInjection(InjectedTestCase.this);
        }
    }
}

