/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.eclipse.sisu.launch;

import io.quarkus.launcher.shaded.com.google.inject.Guice;
import io.quarkus.launcher.shaded.com.google.inject.Injector;
import io.quarkus.launcher.shaded.com.google.inject.Module;
import io.quarkus.launcher.shaded.org.eclipse.sisu.inject.BindingPublisher;
import io.quarkus.launcher.shaded.org.eclipse.sisu.inject.InjectorBindings;
import io.quarkus.launcher.shaded.org.eclipse.sisu.inject.MutableBeanLocator;
import io.quarkus.launcher.shaded.org.eclipse.sisu.launch.BundleModule;
import io.quarkus.launcher.shaded.org.eclipse.sisu.launch.BundlePlan;
import io.quarkus.launcher.shaded.org.osgi.framework.Bundle;

public class SisuBundlePlan
implements BundlePlan {
    protected final MutableBeanLocator locator;

    public SisuBundlePlan(MutableBeanLocator locator) {
        this.locator = locator;
    }

    @Override
    public BindingPublisher prepare(Bundle bundle) {
        return this.appliesTo(bundle) ? new InjectorBindings(this.inject(this.compose(bundle))) : null;
    }

    protected boolean appliesTo(Bundle bundle) {
        if (bundle.getHeaders().get("io.quarkus.launcher.shaded.Bundle-Blueprint") != null) {
            return false;
        }
        String imports = (String)bundle.getHeaders().get("io.quarkus.launcher.shaded.Import-Package");
        return imports != null && (imports.contains("io.quarkus.launcher.shaded.javax.inject") || imports.contains("io.quarkus.launcher.shaded.com.google.inject"));
    }

    protected Injector inject(Module module) {
        return Guice.createInjector(module);
    }

    protected Module compose(Bundle bundle) {
        return new BundleModule(bundle, this.locator);
    }
}

