/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.eclipse.sisu.plexus;

import io.quarkus.launcher.shaded.com.google.inject.Key;
import io.quarkus.launcher.shaded.com.google.inject.Singleton;
import io.quarkus.launcher.shaded.com.google.inject.TypeLiteral;
import io.quarkus.launcher.shaded.com.google.inject.name.Named;
import io.quarkus.launcher.shaded.com.google.inject.name.Names;
import io.quarkus.launcher.shaded.javax.inject.Inject;
import io.quarkus.launcher.shaded.org.eclipse.sisu.inject.BeanLocator;
import io.quarkus.launcher.shaded.org.eclipse.sisu.plexus.DefaultPlexusBeans;
import io.quarkus.launcher.shaded.org.eclipse.sisu.plexus.HintedPlexusBeans;
import io.quarkus.launcher.shaded.org.eclipse.sisu.plexus.PlexusBean;
import io.quarkus.launcher.shaded.org.eclipse.sisu.plexus.PlexusBeanLocator;
import io.quarkus.launcher.shaded.org.eclipse.sisu.plexus.RealmFilteredBeans;
import java.lang.annotation.Annotation;

@Singleton
public final class DefaultPlexusBeanLocator
implements PlexusBeanLocator {
    private final BeanLocator beanLocator;
    private final String visibility;

    @Inject
    public DefaultPlexusBeanLocator(BeanLocator beanLocator) {
        this(beanLocator, null);
    }

    public DefaultPlexusBeanLocator(BeanLocator beanLocator, String visibility) {
        this.beanLocator = beanLocator;
        this.visibility = visibility;
    }

    @Override
    public <T> Iterable<PlexusBean<T>> locate(TypeLiteral<T> role, String ... hints) {
        Key<T> key = hints.length == 1 ? Key.get(role, (Annotation)Names.named(hints[0])) : Key.get(role, Named.class);
        Iterable beans = this.beanLocator.locate(key);
        if ("io.quarkus.launcher.shaded.realm".equalsIgnoreCase(this.visibility)) {
            beans = new RealmFilteredBeans(beans);
        }
        return hints.length <= 1 ? new DefaultPlexusBeans(beans) : new HintedPlexusBeans(beans, role, hints);
    }
}

