/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.eclipse.sisu.plexus;

import io.quarkus.launcher.shaded.com.google.inject.TypeLiteral;
import io.quarkus.launcher.shaded.com.google.inject.spi.InjectionListener;
import io.quarkus.launcher.shaded.com.google.inject.spi.TypeEncounter;
import io.quarkus.launcher.shaded.org.eclipse.sisu.bean.BeanBinder;
import io.quarkus.launcher.shaded.org.eclipse.sisu.bean.BeanManager;
import io.quarkus.launcher.shaded.org.eclipse.sisu.bean.PropertyBinder;
import io.quarkus.launcher.shaded.org.eclipse.sisu.plexus.PlexusBeanMetadata;
import io.quarkus.launcher.shaded.org.eclipse.sisu.plexus.PlexusBeanSource;
import io.quarkus.launcher.shaded.org.eclipse.sisu.plexus.PlexusPropertyBinder;
import java.util.List;

final class PlexusBeanBinder
implements BeanBinder,
InjectionListener<Object> {
    private final BeanManager manager;
    private final PlexusBeanSource[] sources;

    PlexusBeanBinder(BeanManager manager, List<PlexusBeanSource> sources) {
        this.manager = manager;
        this.sources = sources.toArray(new PlexusBeanSource[sources.size()]);
    }

    @Override
    public <B> PropertyBinder bindBean(TypeLiteral<B> type, TypeEncounter<B> encounter) {
        Class<B> clazz = type.getRawType();
        if (this.manager != null && this.manager.manage(clazz)) {
            encounter.register(this);
        }
        PlexusBeanSource[] plexusBeanSourceArray = this.sources;
        int n = this.sources.length;
        int n2 = 0;
        while (n2 < n) {
            PlexusBeanSource source = plexusBeanSourceArray[n2];
            PlexusBeanMetadata metadata = source.getBeanMetadata(clazz);
            if (metadata != null) {
                return new PlexusPropertyBinder(this.manager, encounter, metadata);
            }
            ++n2;
        }
        return null;
    }

    @Override
    public void afterInjection(Object bean) {
        this.manager.manage(bean);
    }
}

