/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.eclipse.sisu.plexus;

import io.quarkus.launcher.shaded.com.google.inject.Guice;
import io.quarkus.launcher.shaded.com.google.inject.Module;
import io.quarkus.launcher.shaded.org.eclipse.sisu.inject.BindingPublisher;
import io.quarkus.launcher.shaded.org.eclipse.sisu.inject.InjectorBindings;
import io.quarkus.launcher.shaded.org.eclipse.sisu.inject.MutableBeanLocator;
import io.quarkus.launcher.shaded.org.eclipse.sisu.launch.BundleModule;
import io.quarkus.launcher.shaded.org.eclipse.sisu.launch.BundlePlan;
import io.quarkus.launcher.shaded.org.eclipse.sisu.plexus.PlexusSpaceModule;
import io.quarkus.launcher.shaded.org.eclipse.sisu.space.BeanScanning;
import io.quarkus.launcher.shaded.org.osgi.framework.Bundle;
import io.quarkus.launcher.shaded.org.osgi.framework.FrameworkUtil;

public class PlexusBundlePlan
implements BundlePlan {
    private static final String SUPPORT_BUNDLE_NAME = FrameworkUtil.getBundle(PlexusSpaceModule.class).getSymbolicName();
    protected final MutableBeanLocator locator;

    public PlexusBundlePlan(MutableBeanLocator locator) {
        this.locator = locator;
    }

    @Override
    public BindingPublisher prepare(Bundle bundle) {
        if (!SUPPORT_BUNDLE_NAME.equals(bundle.getSymbolicName()) && (PlexusBundlePlan.hasPlexusAnnotations(bundle) || PlexusBundlePlan.hasPlexusXml(bundle))) {
            return new InjectorBindings(Guice.createInjector(new BundleModule(bundle, this.locator){

                @Override
                protected Module spaceModule() {
                    return new PlexusSpaceModule(this.space, BeanScanning.select(this.getProperties()));
                }
            }));
        }
        return null;
    }

    protected static boolean hasPlexusAnnotations(Bundle bundle) {
        String imports = (String)bundle.getHeaders().get("io.quarkus.launcher.shaded.Import-Package");
        return imports != null && imports.contains("io.quarkus.launcher.shaded.org.codehaus.plexus.component.annotations");
    }

    protected static boolean hasPlexusXml(Bundle bundle) {
        return bundle.findEntries("META-INF/plexus", "io.quarkus.launcher.shaded.components.xml", false) != null;
    }
}

