/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.eclipse.sisu.plexus;

import io.quarkus.launcher.shaded.com.google.inject.Binder;
import io.quarkus.launcher.shaded.com.google.inject.Module;
import io.quarkus.launcher.shaded.javax.inject.Inject;
import io.quarkus.launcher.shaded.org.codehaus.plexus.PlexusContainer;
import io.quarkus.launcher.shaded.org.codehaus.plexus.context.Context;
import io.quarkus.launcher.shaded.org.codehaus.plexus.context.ContextMapAdapter;
import io.quarkus.launcher.shaded.org.codehaus.plexus.context.DefaultContext;
import io.quarkus.launcher.shaded.org.codehaus.plexus.logging.LoggerManager;
import io.quarkus.launcher.shaded.org.eclipse.sisu.Parameters;
import io.quarkus.launcher.shaded.org.eclipse.sisu.bean.BeanManager;
import io.quarkus.launcher.shaded.org.eclipse.sisu.inject.DeferredProvider;
import io.quarkus.launcher.shaded.org.eclipse.sisu.plexus.DefaultPlexusBeanLocator;
import io.quarkus.launcher.shaded.org.eclipse.sisu.plexus.PlexusAnnotatedBeanModule;
import io.quarkus.launcher.shaded.org.eclipse.sisu.plexus.PlexusBeanConverter;
import io.quarkus.launcher.shaded.org.eclipse.sisu.plexus.PlexusBeanLocator;
import io.quarkus.launcher.shaded.org.eclipse.sisu.plexus.PlexusBeanModule;
import io.quarkus.launcher.shaded.org.eclipse.sisu.plexus.PlexusBindingModule;
import io.quarkus.launcher.shaded.org.eclipse.sisu.plexus.PlexusLifecycleManager;
import io.quarkus.launcher.shaded.org.eclipse.sisu.plexus.PlexusXmlBeanConverter;
import io.quarkus.launcher.shaded.org.eclipse.sisu.plexus.PlexusXmlBeanModule;
import io.quarkus.launcher.shaded.org.eclipse.sisu.plexus.PseudoPlexusContainer;
import io.quarkus.launcher.shaded.org.eclipse.sisu.space.BeanScanning;
import io.quarkus.launcher.shaded.org.eclipse.sisu.space.ClassSpace;
import java.util.ArrayList;
import java.util.Map;

public final class PlexusSpaceModule
implements Module {
    private final ClassSpace space;
    private final BeanScanning scanning;
    private BeanManager delegate;

    public PlexusSpaceModule(ClassSpace space) {
        this(space, BeanScanning.OFF);
    }

    public PlexusSpaceModule(ClassSpace space, BeanScanning scanning) {
        this.space = space;
        this.scanning = scanning;
    }

    @Override
    public void configure(Binder binder) {
        ParameterizedContext context = new ParameterizedContext();
        binder.bind(Context.class).toInstance(context);
        DeferredProvider<?> slf4jLoggerFactoryProvider = this.space.deferLoadClass("io.quarkus.launcher.shaded.org.slf4j.ILoggerFactory").asProvider();
        binder.requestInjection(slf4jLoggerFactoryProvider);
        binder.bind(PlexusBeanConverter.class).to(PlexusXmlBeanConverter.class);
        binder.bind(PlexusBeanLocator.class).to(DefaultPlexusBeanLocator.class);
        binder.bind(PlexusContainer.class).to(PseudoPlexusContainer.class);
        BeanManager manager = this.delegate instanceof PlexusLifecycleManager ? this.delegate : new PlexusLifecycleManager(binder.getProvider(Context.class), binder.getProvider(LoggerManager.class), slf4jLoggerFactoryProvider, this.delegate);
        binder.bind(BeanManager.class).toInstance(manager);
        ArrayList<PlexusBeanModule> beanModules = new ArrayList<PlexusBeanModule>();
        ContextMapAdapter variables = new ContextMapAdapter(context);
        beanModules.add(new PlexusXmlBeanModule(this.space, variables));
        beanModules.add(new PlexusAnnotatedBeanModule(this.space, variables, this.scanning));
        binder.install(new PlexusBindingModule(manager, beanModules));
    }

    public PlexusSpaceModule with(BeanManager manager) {
        this.delegate = manager;
        return this;
    }

    static final class ParameterizedContext
    extends DefaultContext {
        ParameterizedContext() {
        }

        @Inject
        protected void setParameters(@Parameters Map parameters, PlexusContainer container) {
            this.contextData.putAll(parameters);
            this.contextData.put("io.quarkus.launcher.shaded.plexus", container);
        }
    }
}

