/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.eclipse.sisu.plexus;

import io.quarkus.launcher.shaded.org.codehaus.plexus.component.annotations.Requirement;
import io.quarkus.launcher.shaded.org.eclipse.sisu.inject.DeferredClass;
import io.quarkus.launcher.shaded.org.eclipse.sisu.plexus.Hints;
import io.quarkus.launcher.shaded.org.eclipse.sisu.space.LoadedClass;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;

public final class RequirementImpl
implements Requirement {
    private final DeferredClass<?> role;
    private final boolean optional;
    private final String hint;
    private final String[] hints;

    public RequirementImpl(DeferredClass<?> role, boolean optional, List<String> hints) {
        if (role == null || hints == null || hints.contains(null)) {
            throw new IllegalArgumentException("io.quarkus.launcher.shaded.@Requirement cannot contain null values");
        }
        this.role = role;
        this.optional = optional;
        int length = hints.size();
        if (length == 0) {
            this.hint = "io.quarkus.launcher.shaded.";
            this.hints = Hints.NO_HINTS;
        } else if (length == 1) {
            this.hint = hints.get(0);
            this.hints = Hints.NO_HINTS;
        } else {
            this.hint = "io.quarkus.launcher.shaded.";
            this.hints = hints.toArray(new String[length]);
        }
    }

    @Deprecated
    public RequirementImpl(Class<?> role, boolean optional, String ... hints) {
        this(new LoadedClass(role), optional, Arrays.asList(hints));
    }

    @Override
    public Class<?> role() {
        return this.role.load();
    }

    @Override
    public boolean optional() {
        return this.optional;
    }

    @Override
    public String hint() {
        return this.hint;
    }

    @Override
    public String[] hints() {
        return (String[])this.hints.clone();
    }

    @Override
    public boolean equals(Object rhs) {
        if (this == rhs) {
            return true;
        }
        if (rhs instanceof Requirement) {
            Requirement req = (Requirement)rhs;
            return this.role().equals(req.role()) && this.optional == req.optional() && this.hint.equals(req.hint()) && Arrays.equals(this.hints, req.hints());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return (127 * "io.quarkus.launcher.shaded.role".hashCode() ^ this.role().hashCode()) + (127 * "io.quarkus.launcher.shaded.optional".hashCode() ^ Boolean.valueOf(this.optional).hashCode()) + (127 * "io.quarkus.launcher.shaded.hint".hashCode() ^ this.hint.hashCode()) + (127 * "io.quarkus.launcher.shaded.hints".hashCode() ^ Arrays.hashCode(this.hints));
    }

    @Override
    public String toString() {
        return String.format("io.quarkus.launcher.shaded.@%s(hints=%s, optional=%b, role=%s, hint=%s)", Requirement.class.getName(), Arrays.toString(this.hints), this.optional, this.role(), this.hint);
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return Requirement.class;
    }
}

