/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.eclipse.sisu.space;

import io.quarkus.launcher.shaded.com.google.inject.Binder;
import io.quarkus.launcher.shaded.com.google.inject.Key;
import io.quarkus.launcher.shaded.com.google.inject.Module;
import io.quarkus.launcher.shaded.com.google.inject.Scopes;
import io.quarkus.launcher.shaded.com.google.inject.Singleton;
import io.quarkus.launcher.shaded.com.google.inject.TypeLiteral;
import io.quarkus.launcher.shaded.com.google.inject.binder.AnnotatedBindingBuilder;
import io.quarkus.launcher.shaded.com.google.inject.binder.ScopedBindingBuilder;
import io.quarkus.launcher.shaded.com.google.inject.name.Named;
import io.quarkus.launcher.shaded.com.google.inject.name.Names;
import io.quarkus.launcher.shaded.javax.inject.Provider;
import io.quarkus.launcher.shaded.org.eclipse.sisu.EagerSingleton;
import io.quarkus.launcher.shaded.org.eclipse.sisu.Mediator;
import io.quarkus.launcher.shaded.org.eclipse.sisu.Typed;
import io.quarkus.launcher.shaded.org.eclipse.sisu.inject.Legacy;
import io.quarkus.launcher.shaded.org.eclipse.sisu.inject.TypeArguments;
import io.quarkus.launcher.shaded.org.eclipse.sisu.space.MediationListener;
import io.quarkus.launcher.shaded.org.eclipse.sisu.space.QualifiedTypeListener;
import io.quarkus.launcher.shaded.org.eclipse.sisu.space.WildcardKey;
import java.lang.annotation.Annotation;
import java.lang.annotation.IncompleteAnnotationException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;

public final class QualifiedTypeBinder
implements QualifiedTypeListener {
    private static final TypeLiteral<Object> OBJECT_TYPE_LITERAL;
    private static final boolean HAS_JSR299_TYPED;
    private final Binder rootBinder;
    private MediationListener mediationListener;
    private Object currentSource;
    private Binder binder;

    static {
        boolean hasJsr299Typed;
        try {
            hasJsr299Typed = io.quarkus.launcher.shaded.javax.enterprise.inject.Typed.class.isAnnotation();
        }
        catch (LinkageError linkageError) {
            hasJsr299Typed = false;
        }
        HAS_JSR299_TYPED = hasJsr299Typed;
        OBJECT_TYPE_LITERAL = TypeLiteral.get(Object.class);
    }

    public QualifiedTypeBinder(Binder binder) {
        this.rootBinder = binder;
        this.binder = binder;
    }

    public void hear(Class qualifiedType, Object source) {
        if (this.currentSource != source) {
            if (source != null) {
                this.binder = this.rootBinder.withSource(source);
                this.currentSource = source;
            } else {
                this.binder = this.rootBinder;
                this.currentSource = null;
            }
        }
        if (!TypeArguments.isConcrete(qualifiedType)) {
            return;
        }
        if (Module.class.isAssignableFrom(qualifiedType)) {
            this.installModule(qualifiedType);
        } else if (Mediator.class.isAssignableFrom(qualifiedType)) {
            this.registerMediator(qualifiedType);
        } else if (io.quarkus.launcher.shaded.org.sonatype.inject.Mediator.class.isAssignableFrom(qualifiedType)) {
            this.registerLegacyMediator(qualifiedType);
        } else if (Provider.class.isAssignableFrom(qualifiedType)) {
            this.bindProviderType(qualifiedType);
        } else {
            this.bindQualifiedType(qualifiedType);
        }
    }

    private void installModule(Class<Module> moduleType) {
        Module module = this.newInstance(moduleType);
        if (module != null) {
            this.binder.install(module);
        }
    }

    private void registerMediator(Class<Mediator> mediatorType) {
        TypeLiteral<?>[] args = QualifiedTypeBinder.resolveTypeArguments(mediatorType, Mediator.class);
        if (args.length != 3) {
            this.binder.addError(mediatorType + "io.quarkus.launcher.shaded. has wrong number of type arguments", new Object[0]);
        } else {
            Mediator mediator = this.newInstance(mediatorType);
            if (mediator != null) {
                this.mediate(QualifiedTypeBinder.watchedKey(args[1], args[0].getRawType()), mediator, args[2].getRawType());
            }
        }
    }

    private void registerLegacyMediator(Class<io.quarkus.launcher.shaded.org.sonatype.inject.Mediator> mediatorType) {
        TypeLiteral<?>[] args = QualifiedTypeBinder.resolveTypeArguments(mediatorType, io.quarkus.launcher.shaded.org.sonatype.inject.Mediator.class);
        if (args.length != 3) {
            this.binder.addError(mediatorType + "io.quarkus.launcher.shaded. has wrong number of type arguments", new Object[0]);
        } else {
            Mediator mediator = Legacy.adapt(this.newInstance(mediatorType));
            if (mediator != null) {
                this.mediate(QualifiedTypeBinder.watchedKey(args[1], args[0].getRawType()), mediator, args[2].getRawType());
            }
        }
    }

    private void mediate(Key watchedKey, Mediator mediator, Class watcherType) {
        if (this.mediationListener == null) {
            this.mediationListener = new MediationListener(this.binder);
            this.binder.bindListener(this.mediationListener, this.mediationListener);
        }
        this.mediationListener.mediate(watchedKey, mediator, watcherType);
    }

    private void bindProviderType(Class<?> providerType) {
        TypeLiteral<?>[] args = QualifiedTypeBinder.resolveTypeArguments(providerType, Provider.class);
        if (args.length != 1) {
            this.binder.addError(providerType + "io.quarkus.launcher.shaded. has wrong number of type arguments", new Object[0]);
        } else {
            this.binder.bind(providerType).in(Scopes.SINGLETON);
            Named bindingName = QualifiedTypeBinder.getBindingName(providerType);
            Class<?>[] types = QualifiedTypeBinder.getBindingTypes(providerType);
            Key<?> key = QualifiedTypeBinder.getBindingKey(args[0], bindingName);
            ScopedBindingBuilder sbb = this.binder.bind(key).toProvider(providerType);
            if (QualifiedTypeBinder.isEagerSingleton(providerType)) {
                sbb.asEagerSingleton();
            } else if (QualifiedTypeBinder.isSingleton(providerType)) {
                sbb.in(Scopes.SINGLETON);
            }
            if (types != null) {
                Class<?>[] classArray = types;
                int n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> bindingType = classArray[n2];
                    this.binder.bind(key.ofType(bindingType)).to(key);
                    ++n2;
                }
            }
        }
    }

    private void bindQualifiedType(Class<?> qualifiedType) {
        AnnotatedBindingBuilder<?> sbb = this.binder.bind(qualifiedType);
        if (QualifiedTypeBinder.isEagerSingleton(qualifiedType)) {
            sbb.asEagerSingleton();
        }
        Named bindingName = QualifiedTypeBinder.getBindingName(qualifiedType);
        Class<?>[] types = QualifiedTypeBinder.getBindingTypes(qualifiedType);
        if (types != null) {
            Key<Object> key = QualifiedTypeBinder.getBindingKey(OBJECT_TYPE_LITERAL, bindingName);
            Class<?>[] classArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> bindingType = classArray[n2];
                this.binder.bind(key.ofType(bindingType)).to(qualifiedType);
                ++n2;
            }
        } else {
            this.binder.bind(WildcardKey.get(qualifiedType, bindingName)).to(qualifiedType);
        }
    }

    private <T> T newInstance(Class<T> type) {
        try {
            final Constructor<T> ctor = type.getDeclaredConstructor(new Class[0]);
            if (!ctor.isAccessible()) {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        ctor.setAccessible(true);
                        return null;
                    }
                });
            }
            return ctor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            Throwable cause = e instanceof InvocationTargetException ? e.getCause() : e;
            this.binder.addError("io.quarkus.launcher.shaded.Error creating instance of: " + type + "io.quarkus.launcher.shaded. reason: " + cause, new Object[0]);
            return null;
        }
        catch (LinkageError e) {
            this.binder.addError("io.quarkus.launcher.shaded.Error creating instance of: " + type + "io.quarkus.launcher.shaded. reason: " + e, new Object[0]);
            return null;
        }
    }

    private static TypeLiteral<?>[] resolveTypeArguments(Class<?> type, Class<?> superType) {
        return TypeArguments.get(TypeLiteral.get(type).getSupertype(superType));
    }

    private static <T> Key<T> getBindingKey(TypeLiteral<T> bindingType, Annotation qualifier) {
        return qualifier != null ? Key.get(bindingType, qualifier) : Key.get(bindingType);
    }

    private static Named getBindingName(Class<?> qualifiedType) {
        io.quarkus.launcher.shaded.javax.inject.Named jsr330 = qualifiedType.getAnnotation(io.quarkus.launcher.shaded.javax.inject.Named.class);
        if (jsr330 != null) {
            try {
                String name = jsr330.value();
                if (name.length() > 0) {
                    return "io.quarkus.launcher.shaded.default".equals(name) ? null : Names.named(name);
                }
            }
            catch (IncompleteAnnotationException incompleteAnnotationException) {}
        } else {
            String name;
            Named guice = qualifiedType.getAnnotation(Named.class);
            if (guice != null && (name = guice.value()).length() > 0) {
                return "io.quarkus.launcher.shaded.default".equals(name) ? null : guice;
            }
        }
        if (qualifiedType.getSimpleName().startsWith("io.quarkus.launcher.shaded.Default")) {
            return null;
        }
        return Names.named(qualifiedType.getName());
    }

    private static Class<?>[] getBindingTypes(Class<?> clazz) {
        Class<?> c = clazz;
        while (c != null && c != Object.class) {
            Object typed;
            if (HAS_JSR299_TYPED && (typed = c.getAnnotation(io.quarkus.launcher.shaded.javax.enterprise.inject.Typed.class)) != null) {
                return typed.value().length > 0 ? typed.value() : c.getInterfaces();
            }
            typed = c.getAnnotation(Typed.class);
            if (typed != null) {
                return typed.value().length > 0 ? typed.value() : c.getInterfaces();
            }
            c = c.getSuperclass();
        }
        return null;
    }

    private static boolean isSingleton(Class<?> type) {
        return type.isAnnotationPresent(io.quarkus.launcher.shaded.javax.inject.Singleton.class) || type.isAnnotationPresent(Singleton.class);
    }

    private static boolean isEagerSingleton(Class<?> type) {
        return type.isAnnotationPresent(EagerSingleton.class) || type.isAnnotationPresent(io.quarkus.launcher.shaded.org.sonatype.inject.EagerSingleton.class);
    }

    private static <T> Key<T> watchedKey(TypeLiteral<T> type, Class qualifierType) {
        return qualifierType.isAnnotation() ? Key.get(type, (Class<? extends Annotation>)qualifierType) : Key.get(type);
    }
}

