/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.eclipse.sisu.space;

import io.quarkus.launcher.shaded.org.eclipse.sisu.space.AnnotationVisitor;
import io.quarkus.launcher.shaded.org.eclipse.sisu.space.ClassSpace;
import io.quarkus.launcher.shaded.org.eclipse.sisu.space.ClassVisitor;
import io.quarkus.launcher.shaded.org.eclipse.sisu.space.SpaceScanner;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

final class QualifierCache
implements ClassVisitor {
    private static final String QUALIFIER_DESC = "Lio/quarkus/launcher/shaded/javax/inject/Qualifier;";
    private static final String NAMED_DESC = "Lio/quarkus/launcher/shaded/javax/inject/Named;";
    private static final Map<String, Boolean> cachedResults = new ConcurrentHashMap<String, Boolean>(32, 0.75f, 1);
    private boolean isQualified;

    QualifierCache() {
    }

    @Override
    public void enterClass(int modifiers, String name, String _extends, String[] _implements) {
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc) {
        this.isQualified |= QUALIFIER_DESC.equals(desc);
        return null;
    }

    @Override
    public void leaveClass() {
    }

    boolean qualify(ClassSpace space, String desc) {
        if (NAMED_DESC.equals(desc)) {
            return true;
        }
        Boolean result = cachedResults.get(desc);
        if (result == null) {
            this.isQualified = false;
            String name = desc.substring(1, desc.length() - 1);
            SpaceScanner.accept(this, space.getResource(String.valueOf(name) + "io.quarkus.launcher.shaded..class"));
            cachedResults.put(desc, this.isQualified);
            return this.isQualified;
        }
        return result;
    }
}

