/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.eclipse.sisu.space;

import io.quarkus.launcher.shaded.org.eclipse.sisu.inject.Logs;
import io.quarkus.launcher.shaded.org.eclipse.sisu.space.AbstractSisuIndex;
import io.quarkus.launcher.shaded.org.eclipse.sisu.space.AnnotationVisitor;
import io.quarkus.launcher.shaded.org.eclipse.sisu.space.ClassSpace;
import io.quarkus.launcher.shaded.org.eclipse.sisu.space.ClassVisitor;
import io.quarkus.launcher.shaded.org.eclipse.sisu.space.QualifierCache;
import io.quarkus.launcher.shaded.org.eclipse.sisu.space.SpaceScanner;
import io.quarkus.launcher.shaded.org.eclipse.sisu.space.SpaceVisitor;
import io.quarkus.launcher.shaded.org.eclipse.sisu.space.URLClassSpace;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;

public class SisuIndex
extends AbstractSisuIndex
implements SpaceVisitor,
ClassVisitor {
    private final QualifierCache qualifierCache = new QualifierCache();
    private final File targetDirectory;
    private ClassSpace space;
    private String clazzName;

    public SisuIndex(File targetDirectory) {
        this.targetDirectory = targetDirectory;
    }

    public static void main(String[] args) {
        ArrayList<URL> indexPath = new ArrayList<URL>(args.length);
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            try {
                indexPath.add(new File(path).toURI().toURL());
            }
            catch (MalformedURLException e) {
                Logs.warn("io.quarkus.launcher.shaded.Bad classpath element: {}", path, e);
            }
            ++n2;
        }
        ClassLoader parent = SisuIndex.class.getClassLoader();
        URL[] urls = indexPath.toArray(new URL[indexPath.size()]);
        ClassLoader loader = urls.length > 0 ? URLClassLoader.newInstance(urls, parent) : parent;
        new SisuIndex(new File("io.quarkus.launcher.shaded..")).index(new URLClassSpace(loader));
    }

    public final void index(ClassSpace _space) {
        try {
            new SpaceScanner(_space).accept(this);
        }
        finally {
            this.flushIndex();
        }
    }

    @Override
    public final void enterSpace(ClassSpace _space) {
        this.space = _space;
    }

    @Override
    public final ClassVisitor visitClass(URL url) {
        return this;
    }

    @Override
    public final void enterClass(int modifiers, String name, String _extends, String[] _implements) {
        if ((modifiers & 0x7600) == 0) {
            this.clazzName = name;
        }
    }

    @Override
    public final AnnotationVisitor visitAnnotation(String desc) {
        if (this.clazzName != null && this.qualifierCache.qualify(this.space, desc)) {
            this.addClassToIndex("io.quarkus.launcher.shaded.javax.inject.Named", this.clazzName.replace('/', '.'));
        }
        return null;
    }

    @Override
    public final void leaveClass() {
        this.clazzName = null;
    }

    @Override
    public final void leaveSpace() {
        this.space = null;
    }

    @Override
    protected void info(String message) {
        System.out.println("io.quarkus.launcher.shaded.[INFO] " + message);
    }

    @Override
    protected void warn(String message) {
        System.out.println("io.quarkus.launcher.shaded.[WARN] " + message);
    }

    @Override
    protected Reader getReader(String path) throws IOException {
        return new InputStreamReader((InputStream)new FileInputStream(new File(this.targetDirectory, path)), "io.quarkus.launcher.shaded.UTF-8");
    }

    @Override
    protected Writer getWriter(String path) throws IOException {
        File index = new File(this.targetDirectory, path);
        File parent = index.getParentFile();
        if (parent.isDirectory() || parent.mkdirs()) {
            return new OutputStreamWriter((OutputStream)new FileOutputStream(index), "io.quarkus.launcher.shaded.UTF-8");
        }
        throw new IOException("io.quarkus.launcher.shaded.Error creating: " + parent);
    }
}

