/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.eclipse.sisu.space;

import io.quarkus.launcher.shaded.javax.annotation.processing.Completion;
import io.quarkus.launcher.shaded.javax.annotation.processing.ProcessingEnvironment;
import io.quarkus.launcher.shaded.javax.annotation.processing.Processor;
import io.quarkus.launcher.shaded.javax.annotation.processing.RoundEnvironment;
import io.quarkus.launcher.shaded.javax.inject.Qualifier;
import io.quarkus.launcher.shaded.javax.lang.model.SourceVersion;
import io.quarkus.launcher.shaded.javax.lang.model.element.AnnotationMirror;
import io.quarkus.launcher.shaded.javax.lang.model.element.Element;
import io.quarkus.launcher.shaded.javax.lang.model.element.ExecutableElement;
import io.quarkus.launcher.shaded.javax.lang.model.element.TypeElement;
import io.quarkus.launcher.shaded.javax.lang.model.util.Elements;
import io.quarkus.launcher.shaded.javax.tools.Diagnostic;
import io.quarkus.launcher.shaded.javax.tools.FileObject;
import io.quarkus.launcher.shaded.javax.tools.JavaFileManager;
import io.quarkus.launcher.shaded.javax.tools.StandardLocation;
import io.quarkus.launcher.shaded.org.eclipse.sisu.space.AbstractSisuIndex;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.Collections;
import java.util.Set;

public final class SisuIndexAPT6
extends AbstractSisuIndex
implements Processor {
    private static final String QUALIFIERS = "io.quarkus.launcher.shaded.qualifiers";
    private static final String ALL = "io.quarkus.launcher.shaded.all";
    private static final String NONE = "io.quarkus.launcher.shaded.none";
    private static final boolean HAS_QUALIFIER;
    private ProcessingEnvironment environment;
    private String qualifiers;

    static {
        boolean hasQualifier;
        try {
            hasQualifier = Qualifier.class.isAnnotation();
        }
        catch (LinkageError linkageError) {
            hasQualifier = false;
        }
        HAS_QUALIFIER = hasQualifier;
    }

    public void init(ProcessingEnvironment _environment) {
        this.environment = _environment;
        this.qualifiers = (String)_environment.getOptions().get(QUALIFIERS);
    }

    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment round) {
        Elements elementUtils = this.environment.getElementUtils();
        for (TypeElement typeElement : annotations) {
            if (ALL.equals(this.qualifiers) && !SisuIndexAPT6.hasQualifier(typeElement)) continue;
            for (Element elem : round.getElementsAnnotatedWith(typeElement)) {
                if (!elem.getKind().isClass()) continue;
                this.addClassToIndex("io.quarkus.launcher.shaded.javax.inject.Named", elementUtils.getBinaryName((TypeElement)elem));
            }
        }
        if (round.processingOver()) {
            this.flushIndex();
        }
        return false;
    }

    public Iterable<? extends Completion> getCompletions(Element element, AnnotationMirror annotation, ExecutableElement member, String userText) {
        return Collections.emptySet();
    }

    public Set<String> getSupportedAnnotationTypes() {
        if (ALL.equalsIgnoreCase(this.qualifiers)) {
            return Collections.singleton("io.quarkus.launcher.shaded.*");
        }
        if (NONE.equalsIgnoreCase(this.qualifiers)) {
            return Collections.emptySet();
        }
        return Collections.singleton("io.quarkus.launcher.shaded.javax.inject.Named");
    }

    public Set<String> getSupportedOptions() {
        return Collections.singleton(QUALIFIERS);
    }

    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    protected void info(String msg) {
        this.environment.getMessager().printMessage(Diagnostic.Kind.NOTE, (CharSequence)msg);
    }

    @Override
    protected void warn(String msg) {
        this.environment.getMessager().printMessage(Diagnostic.Kind.WARNING, (CharSequence)msg);
    }

    @Override
    protected Reader getReader(String path) throws IOException {
        FileObject file = this.environment.getFiler().getResource((JavaFileManager.Location)StandardLocation.CLASS_OUTPUT, (CharSequence)"io.quarkus.launcher.shaded.", (CharSequence)path);
        return new InputStreamReader(file.openInputStream(), "io.quarkus.launcher.shaded.UTF-8");
    }

    @Override
    protected Writer getWriter(String path) throws IOException {
        return this.environment.getFiler().createResource((JavaFileManager.Location)StandardLocation.CLASS_OUTPUT, (CharSequence)"io.quarkus.launcher.shaded.", (CharSequence)path, new Element[0]).openWriter();
    }

    private static boolean hasQualifier(TypeElement anno) {
        if (HAS_QUALIFIER) {
            return anno.getAnnotation(Qualifier.class) != null;
        }
        for (AnnotationMirror mirror : anno.getAnnotationMirrors()) {
            if (!"io.quarkus.launcher.shaded.javax.inject.Qualifier".equals(mirror.getAnnotationType().toString())) continue;
            return true;
        }
        return false;
    }
}

