/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.eclipse.sisu.space;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Locale;

public final class Streams {
    private static final boolean ON_WINDOWS;

    static {
        boolean onWindows;
        try {
            onWindows = System.getProperty("io.quarkus.launcher.shaded.os.name").toLowerCase(Locale.US).contains("io.quarkus.launcher.shaded.windows");
        }
        catch (RuntimeException runtimeException) {
            onWindows = false;
        }
        ON_WINDOWS = onWindows;
    }

    private Streams() {
    }

    public static InputStream open(URL url) throws IOException {
        if (ON_WINDOWS) {
            URLConnection conn = url.openConnection();
            conn.setUseCaches(false);
            return conn.getInputStream();
        }
        return url.openStream();
    }
}

