/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.eclipse.sisu.wire;

import io.quarkus.launcher.shaded.com.google.inject.Key;
import io.quarkus.launcher.shaded.com.google.inject.Provider;
import io.quarkus.launcher.shaded.com.google.inject.ProvisionException;
import io.quarkus.launcher.shaded.com.google.inject.TypeLiteral;
import io.quarkus.launcher.shaded.com.google.inject.name.Named;
import io.quarkus.launcher.shaded.com.google.inject.name.Names;
import io.quarkus.launcher.shaded.com.google.inject.spi.TypeConverter;
import io.quarkus.launcher.shaded.javax.inject.Inject;
import io.quarkus.launcher.shaded.org.eclipse.sisu.Parameters;
import io.quarkus.launcher.shaded.org.eclipse.sisu.inject.BeanLocator;
import io.quarkus.launcher.shaded.org.eclipse.sisu.wire.BeanProviders;
import io.quarkus.launcher.shaded.org.eclipse.sisu.wire.TypeConverterCache;
import java.lang.annotation.Annotation;
import java.util.Map;

final class PlaceholderBeanProvider<V>
implements Provider<V> {
    private static final int EXPRESSION_RECURSION_LIMIT = 8;
    @Inject
    @Parameters
    private Map properties;
    @Inject
    private TypeConverterCache converterCache;
    private final Provider<BeanLocator> locator;
    private final Key<V> placeholderKey;

    PlaceholderBeanProvider(Provider<BeanLocator> locator, Key<V> key) {
        this.locator = locator;
        this.placeholderKey = key;
    }

    @Override
    public V get() {
        V bean;
        TypeLiteral<V> expectedType;
        Class<V> clazz;
        String template = ((Named)this.placeholderKey.getAnnotation()).value();
        Object value = this.interpolate(template, clazz = (expectedType = this.placeholderKey.getTypeLiteral()).getRawType());
        if (!(value instanceof String)) {
            return (V)value;
        }
        Key<V> lookupKey = Key.get(expectedType, (Annotation)Names.named((String)value));
        if (String.class != clazz && (bean = this.lookup(lookupKey)) != null) {
            return bean;
        }
        if (template == value) {
            value = PlaceholderBeanProvider.nullify(this.lookup(lookupKey.ofType(String.class)));
        }
        if (value == null || String.class == clazz) {
            return (V)value;
        }
        TypeConverter converter = this.converterCache.getTypeConverter(expectedType);
        if (converter != null) {
            return (V)converter.convert((String)value, expectedType);
        }
        return null;
    }

    private <T> T lookup(Key<T> key) {
        return BeanProviders.firstOf(this.locator.get().locate(key));
    }

    private static String nullify(String value) {
        return "io.quarkus.launcher.shaded.null".equals(value) ? null : value;
    }

    private Object interpolate(String template, Class<?> clazz) {
        int y;
        StringBuilder buf;
        if (template.contains("io.quarkus.launcher.shaded.${")) {
            buf = new StringBuilder(template);
        } else if (this.properties.containsKey(template)) {
            buf = new StringBuilder("io.quarkus.launcher.shaded.${").append(template).append('}');
        } else {
            return template;
        }
        int x = 0;
        int expressionEnd = 0;
        int expressionNum = 0;
        while ((x = buf.indexOf("io.quarkus.launcher.shaded.${", x)) >= 0 && (y = buf.indexOf("io.quarkus.launcher.shaded.}", x) + 1) > 0) {
            String key;
            int anchor;
            Object value;
            if (y > expressionEnd) {
                expressionNum = 0;
                expressionEnd = y;
            }
            if ((value = this.properties.get((anchor = (key = buf.substring(x + 2, y - 1)).indexOf("io.quarkus.launcher.shaded.:-")) < 0 ? key : key.substring(0, anchor))) == null && anchor >= 0) {
                value = key.substring(anchor + 2);
            }
            if (expressionNum++ >= 8) {
                throw new ProvisionException("io.quarkus.launcher.shaded.Recursive configuration: " + template + "io.quarkus.launcher.shaded. stopped at: " + buf);
            }
            int len = buf.length();
            if (x == 0 && len == y && String.class != clazz && clazz.isInstance(value)) {
                return value;
            }
            buf.replace(x, y, String.valueOf(value));
            expressionEnd += buf.length() - len;
        }
        return PlaceholderBeanProvider.nullify(buf.toString());
    }
}

