/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.eclipse.sisu.wire;

import io.quarkus.launcher.shaded.com.google.inject.Injector;
import io.quarkus.launcher.shaded.com.google.inject.Singleton;
import io.quarkus.launcher.shaded.com.google.inject.TypeLiteral;
import io.quarkus.launcher.shaded.com.google.inject.spi.TypeConverter;
import io.quarkus.launcher.shaded.com.google.inject.spi.TypeConverterBinding;
import io.quarkus.launcher.shaded.javax.inject.Inject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Singleton
final class TypeConverterCache {
    private final Map<TypeLiteral<?>, TypeConverter> converterMap = new ConcurrentHashMap(16, 0.75f, 1);
    private final Injector injector;

    @Inject
    TypeConverterCache(Injector injector) {
        this.injector = injector;
    }

    public TypeConverter getTypeConverter(TypeLiteral<?> type) {
        TypeConverter converter = this.converterMap.get(type);
        if (converter == null) {
            for (TypeConverterBinding b : this.injector.getTypeConverterBindings()) {
                if (!b.getTypeMatcher().matches(type)) continue;
                converter = b.getTypeConverter();
                this.converterMap.put(type, converter);
                break;
            }
        }
        return converter;
    }
}

