/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.jboss.logging;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;

class LoggingLocale {
    private static final Locale LOCALE = LoggingLocale.getDefaultLocale();

    LoggingLocale() {
    }

    static Locale getLocale() {
        return LOCALE;
    }

    private static Locale getDefaultLocale() {
        String bcp47Tag = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("io.quarkus.launcher.shaded.org.jboss.logging.locale", "io.quarkus.launcher.shaded.");
            }
        });
        if (bcp47Tag.trim().isEmpty()) {
            return Locale.getDefault();
        }
        return LoggingLocale.forLanguageTag(bcp47Tag);
    }

    private static Locale forLanguageTag(String locale) {
        if ("io.quarkus.launcher.shaded.en-CA".equalsIgnoreCase(locale)) {
            return Locale.CANADA;
        }
        if ("io.quarkus.launcher.shaded.fr-CA".equalsIgnoreCase(locale)) {
            return Locale.CANADA_FRENCH;
        }
        if ("io.quarkus.launcher.shaded.zh".equalsIgnoreCase(locale)) {
            return Locale.CHINESE;
        }
        if ("io.quarkus.launcher.shaded.en".equalsIgnoreCase(locale)) {
            return Locale.ENGLISH;
        }
        if ("io.quarkus.launcher.shaded.fr-FR".equalsIgnoreCase(locale)) {
            return Locale.FRANCE;
        }
        if ("io.quarkus.launcher.shaded.fr".equalsIgnoreCase(locale)) {
            return Locale.FRENCH;
        }
        if ("io.quarkus.launcher.shaded.de".equalsIgnoreCase(locale)) {
            return Locale.GERMAN;
        }
        if ("io.quarkus.launcher.shaded.de-DE".equalsIgnoreCase(locale)) {
            return Locale.GERMANY;
        }
        if ("io.quarkus.launcher.shaded.it".equalsIgnoreCase(locale)) {
            return Locale.ITALIAN;
        }
        if ("io.quarkus.launcher.shaded.it-IT".equalsIgnoreCase(locale)) {
            return Locale.ITALY;
        }
        if ("io.quarkus.launcher.shaded.ja-JP".equalsIgnoreCase(locale)) {
            return Locale.JAPAN;
        }
        if ("io.quarkus.launcher.shaded.ja".equalsIgnoreCase(locale)) {
            return Locale.JAPANESE;
        }
        if ("io.quarkus.launcher.shaded.ko-KR".equalsIgnoreCase(locale)) {
            return Locale.KOREA;
        }
        if ("io.quarkus.launcher.shaded.ko".equalsIgnoreCase(locale)) {
            return Locale.KOREAN;
        }
        if ("io.quarkus.launcher.shaded.zh-CN".equalsIgnoreCase(locale)) {
            return Locale.SIMPLIFIED_CHINESE;
        }
        if ("io.quarkus.launcher.shaded.zh-TW".equalsIgnoreCase(locale)) {
            return Locale.TRADITIONAL_CHINESE;
        }
        if ("io.quarkus.launcher.shaded.en-UK".equalsIgnoreCase(locale)) {
            return Locale.UK;
        }
        if ("io.quarkus.launcher.shaded.en-US".equalsIgnoreCase(locale)) {
            return Locale.US;
        }
        String[] parts = locale.split("io.quarkus.launcher.shaded.-");
        int len = parts.length;
        int index = 0;
        int count = 0;
        String language = parts[index++];
        String region = "io.quarkus.launcher.shaded.";
        String variant = "io.quarkus.launcher.shaded.";
        while (index < len && count++ != 2 && LoggingLocale.isAlpha(parts[index], 3, 3)) {
            ++index;
        }
        if (index != len && LoggingLocale.isAlpha(parts[index], 4, 4)) {
            ++index;
        }
        if (index != len && (LoggingLocale.isAlpha(parts[index], 2, 2) || LoggingLocale.isNumeric(parts[index], 3, 3))) {
            region = parts[index++];
        }
        if (index != len && LoggingLocale.isAlphaOrNumeric(parts[index], 5, 8)) {
            variant = parts[index];
        }
        return new Locale(language, region, variant);
    }

    private static boolean isAlpha(String value, int minLen, int maxLen) {
        int len = value.length();
        if (len < minLen || len > maxLen) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (Character.isLetter(value.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isNumeric(String value, int minLen, int maxLen) {
        int len = value.length();
        if (len < minLen || len > maxLen) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (Character.isDigit(value.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isAlphaOrNumeric(String value, int minLen, int maxLen) {
        int len = value.length();
        if (len < minLen || len > maxLen) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (Character.isLetterOrDigit(value.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

